/*
 * Decompiled with CFR 0.152.
 */
package dev.stick_stack.dimensionviewer;

import dev.stick_stack.dimensionviewer.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerListHandler {
    public static final List<Player> playerList = new ArrayList<Player>();

    public MutableComponent makeDimensionComponent(Player player, String format) {
        ResourceLocation dimension = player.level().dimension().location();
        return this.extractTokensFromFormat(format, dimension);
    }

    private MutableComponent extractTokensFromFormat(String format, ResourceLocation dimension) {
        MutableComponent component = MutableComponent.create((ComponentContents)PlainTextContents.EMPTY);
        format = this.replaceTokens(format);
        String aliasedDim = this.checkForAliases(dimension.toString());
        component.append(format.split("%d")[0]);
        aliasedDim = aliasedDim.replace("%d", CommonUtils.dimensionToString(dimension));
        Style tempStyle = Style.EMPTY;
        int i = 0;
        for (String word : aliasedDim.split(" ")) {
            tempStyle = this.checkTokens(tempStyle, word);
            component.append((Component)Component.literal((String)this.replaceTokens(word)).withStyle(tempStyle));
            if (i < aliasedDim.split(" ").length - 1) {
                component.append(" ");
            }
            if (word.endsWith("%r")) {
                tempStyle = Style.EMPTY;
            }
            ++i;
        }
        component.append(format.split("%d")[1]);
        return component;
    }

    private Style checkTokens(@Nullable Style inStyle, String inString) {
        if (inString.startsWith("%r")) {
            return this.checkTokens(Style.EMPTY, inString.substring(2));
        }
        inStyle = inStyle == null ? Style.EMPTY : inStyle;
        boolean useItalic = inString.contains("%i");
        boolean useBold = inString.contains("%b");
        boolean useUnderline = inString.contains("%u");
        boolean useStrikethrough = inString.contains("%s");
        boolean useObfuscate = inString.contains("%o");
        inStyle = inStyle.withItalic(Boolean.valueOf(inStyle.isItalic() || useItalic)).withBold(Boolean.valueOf(inStyle.isBold() || useBold)).withUnderlined(Boolean.valueOf(inStyle.isUnderlined() || useUnderline)).withStrikethrough(Boolean.valueOf(inStyle.isStrikethrough() || useStrikethrough)).withObfuscated(Boolean.valueOf(inStyle.isObfuscated() || useObfuscate));
        return inStyle;
    }

    private String replaceTokens(String inString) {
        for (String token : new String[]{"%i", "%b", "%u", "%s", "%o"}) {
            inString = inString.replace(token, "");
        }
        inString = inString.replaceAll("%[^%d].*?", "");
        inString = inString.replace("%%", "%");
        return inString;
    }

    public abstract String checkForAliases(String var1);
}

