/*
 * Decompiled with CFR 0.152.
 */
package dev.stick_stack.dimensionviewer;

import com.mojang.brigadier.CommandDispatcher;
import dev.stick_stack.dimensionviewer.CommonUtils;
import dev.stick_stack.dimensionviewer.ConfigNeoForge;
import dev.stick_stack.dimensionviewer.Constants;
import dev.stick_stack.dimensionviewer.CustomCommands;
import dev.stick_stack.dimensionviewer.PlayerListHandler;
import dev.stick_stack.dimensionviewer.PlayerListHandlerNeoForge;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@Mod(value="dimensionviewer")
public class DimensionViewerNeoForge {
    public DimensionViewerNeoForge(ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigNeoForge.CONFIG);
    }

    @EventBusSubscriber(modid="dimensionviewer", bus=EventBusSubscriber.Bus.MOD)
    private static class ModEventBusEvents {
        private ModEventBusEvents() {
        }

        @SubscribeEvent
        public static void onConfigReloaded(ModConfigEvent.Reloading event) {
            if (event.getConfig().getModId().contains("dimensionviewer")) {
                Constants.LOG.info("Config file reloaded!");
                if (!PlayerListHandler.playerList.isEmpty()) {
                    MinecraftServer server = PlayerListHandler.playerList.get(0).getServer();
                    server.getPlayerList().getPlayers().forEach(Player::refreshDisplayName);
                    server.getPlayerList().getPlayers().forEach(ServerPlayer::refreshTabListName);
                } else {
                    Constants.LOG.info("Skipping player refresh as there are no players...");
                }
            }
        }
    }

    @EventBusSubscriber(modid="dimensionviewer", bus=EventBusSubscriber.Bus.GAME)
    private static class ModEventBus {
        private ModEventBus() {
        }

        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            CustomCommands.RegisterCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    @EventBusSubscriber(modid="dimensionviewer", value={Dist.DEDICATED_SERVER})
    private static class PlayerEventHandler {
        private PlayerEventHandler() {
        }

        private static void refreshPlayerDetails(PlayerEvent event) {
            List players = event.getEntity().getServer().getPlayerList().getPlayers();
            players.forEach(Player::refreshDisplayName);
            players.forEach(ServerPlayer::refreshTabListName);
        }

        private static Style tryGetColor(String color) {
            try {
                ChatFormatting format = ChatFormatting.valueOf((String)color);
                return Style.EMPTY.withColor(format);
            }
            catch (IllegalArgumentException exception) {
                for (String entry : (List)ConfigNeoForge.CUSTOM_COLORS.get()) {
                    String[] splits = entry.split(" ");
                    if (!color.equals(splits[0])) continue;
                    if (splits[1].startsWith("#")) {
                        return Style.EMPTY.withColor(CommonUtils.hexToInt(splits[1]));
                    }
                    int r = Integer.parseInt(splits[1].substring(1));
                    int g = Integer.parseInt(splits[2].substring(1));
                    int b = Integer.parseInt(splits[3].substring(1));
                    return Style.EMPTY.withColor(CommonUtils.rgbToInt(r, g, b));
                }
                return Style.EMPTY;
            }
        }

        private static Component createDimensionComponent(PlayerEvent event, MutableComponent originalName) {
            ResourceLocation dimension = event.getEntity().level().dimension().location();
            String dimSource = CommonUtils.dimensionToString(dimension);
            PlayerListHandlerNeoForge handler = new PlayerListHandlerNeoForge();
            Style style = Style.EMPTY;
            boolean foundModdedDim = false;
            if (((Boolean)ConfigNeoForge.PER_DIM_COLOR.get()).booleanValue()) {
                for (String modDim : (List)ConfigNeoForge.MODDED_DIMS.get()) {
                    Pattern modDimPattern = Pattern.compile(modDim.split(" ")[0]);
                    if (!modDimPattern.matcher(dimension.toString()).find()) continue;
                    style = PlayerEventHandler.tryGetColor(modDim.split(" ")[1]);
                    foundModdedDim = true;
                    break;
                }
                if (!foundModdedDim) {
                    style = switch (dimension.toString()) {
                        case "minecraft:overworld" -> PlayerEventHandler.tryGetColor((String)ConfigNeoForge.OVERWORLD_COLOR.get());
                        case "minecraft:the_nether" -> PlayerEventHandler.tryGetColor((String)ConfigNeoForge.NETHER_COLOR.get());
                        case "minecraft:the_end" -> PlayerEventHandler.tryGetColor((String)ConfigNeoForge.END_COLOR.get());
                        default -> PlayerEventHandler.tryGetColor((String)ConfigNeoForge.DEFAULT_COLOR.get());
                    };
                }
            } else {
                style = PlayerEventHandler.tryGetColor((String)ConfigNeoForge.DEFAULT_COLOR.get());
            }
            MutableComponent dimComponent = handler.makeDimensionComponent(event.getEntity(), (String)ConfigNeoForge.LIST_FORMAT.get()).withStyle(style);
            if (((Boolean)ConfigNeoForge.CHAT_DIM_HOVER.get()).booleanValue()) {
                dimComponent.withStyle(dimComponent.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)dimSource))));
            }
            MutableComponent spacer = MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(" "));
            if (ConfigNeoForge.DIM_POSITION.get() == CommonUtils.DimensionPosition.PREPEND) {
                spacer.setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE)).append((Component)originalName);
                spacer.append((Component)Component.empty().withStyle(ChatFormatting.RESET));
                return dimComponent.append((Component)spacer);
            }
            spacer.append((Component)dimComponent);
            spacer.append((Component)Component.empty().withStyle(ChatFormatting.RESET));
            return originalName.append((Component)spacer);
        }

        @SubscribeEvent
        public static void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerListHandler.playerList.add(event.getEntity());
            PlayerEventHandler.refreshPlayerDetails((PlayerEvent)event);
        }

        @SubscribeEvent
        public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
            PlayerListHandler.playerList.remove(event.getEntity());
            PlayerEventHandler.refreshPlayerDetails((PlayerEvent)event);
        }

        @SubscribeEvent
        public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
            PlayerEventHandler.refreshPlayerDetails((PlayerEvent)event);
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            PlayerEventHandler.refreshPlayerDetails((PlayerEvent)event);
        }

        @SubscribeEvent
        public static void changeDisplayName(PlayerEvent.NameFormat event) {
            if (!((Boolean)ConfigNeoForge.DIM_IN_CHAT_NAME.get()).booleanValue()) {
                return;
            }
            event.setDisplayname(PlayerEventHandler.createDimensionComponent((PlayerEvent)event, event.getDisplayname().copy()));
        }

        @SubscribeEvent
        public static void changeTabListName(PlayerEvent.TabListNameFormat event) {
            if (((Boolean)ConfigNeoForge.DIM_IN_CHAT_NAME.get()).booleanValue()) {
                event.setDisplayName(event.getEntity().getDisplayName());
            } else {
                MutableComponent originalName = event.getEntity().getDisplayName().copy();
                event.setDisplayName(PlayerEventHandler.createDimensionComponent((PlayerEvent)event, originalName));
            }
        }
    }
}

