/*
 * Decompiled with CFR 0.152.
 */
package dev.stick_stack.dimensionviewer;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.stick_stack.dimensionviewer.CommonUtils;
import dev.stick_stack.dimensionviewer.platform.Services;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;

public class CustomCommands {
    public static void RegisterCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dimensionviewer").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").executes(CustomCommands::getDimensionId)).then(Commands.literal((String)"color").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> {
            String dim = DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension").dimension().location().toString();
            String value = Services.CONFIG.GetCustomColor(dim);
            if (value != null) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Color for dimension %s: '%s'".formatted(dim, value)), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to get color of dimension: %s".formatted(value)));
            return 0;
        })))).then(Commands.literal((String)"alias").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> {
            String dim = DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension").dimension().location().toString();
            String value = Services.CONFIG.GetAlias(dim);
            if (Services.CONFIG.HasAlias(dim)) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"The alias for dimension %s is '%s'".formatted(dim, value)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"There is no alias set for dimension '%s'".formatted(dim)), true);
            }
            return 1;
        })))).then(Commands.literal((String)"format").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Current dimension format: %s".formatted(Services.CONFIG.ListFormat())), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").requires(src -> src.hasPermission(3))).then(Commands.literal((String)"color").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"custom_color", (ArgumentType)ColorArgument.color()).executes(ctx -> {
            String dim = DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension").dimension().location().toString();
            String color = ColorArgument.getColor((CommandContext)ctx, (String)"custom_color").getSerializedName().toUpperCase(Locale.ROOT);
            Services.CONFIG.SetColor(dim, color);
            CustomCommands.refreshDisplayNames((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Set color of dimension %s to '%s'".formatted(dim, color)), true);
            return 1;
        }))))).then(Commands.literal((String)"alias").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"alias", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String dim = DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension").dimension().location().toString();
            String alias = StringArgumentType.getString((CommandContext)ctx, (String)"alias");
            Services.CONFIG.SetAlias(dim, alias);
            CustomCommands.refreshDisplayNames((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Set alias of dimension %s to '%s'".formatted(dim, alias)), true);
            return 1;
        }))))).then(Commands.literal((String)"format").then(Commands.argument((String)"format", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String format = StringArgumentType.getString((CommandContext)ctx, (String)"format");
            Services.CONFIG.SetFormat(format);
            CustomCommands.refreshDisplayNames((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Changed format to '%s'".formatted(format)), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"boolean").then(Commands.literal((String)"per_dim_color").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CustomCommands.setBoolSetting((CommandContext<CommandSourceStack>)ctx, "perDimColor"))))).then(Commands.literal((String)"dim_in_chat_name").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CustomCommands.setBoolSetting((CommandContext<CommandSourceStack>)ctx, "dimInChatName"))))).then(Commands.literal((String)"chat_dim_hover").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CustomCommands.setBoolSetting((CommandContext<CommandSourceStack>)ctx, "chatDimHover"))))).then(Commands.literal((String)"enable_aliases").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CustomCommands.setBoolSetting((CommandContext<CommandSourceStack>)ctx, "enableAliases")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"position").then(Commands.literal((String)"prepend").executes(ctx -> {
            Services.CONFIG.SetPlacement(CommonUtils.DimensionPosition.PREPEND);
            CustomCommands.refreshDisplayNames((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Set dimension position to 'PREPEND'"), true);
            return 1;
        }))).then(Commands.literal((String)"append").executes(ctx -> {
            Services.CONFIG.SetPlacement(CommonUtils.DimensionPosition.APPEND);
            CustomCommands.refreshDisplayNames((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Set dimension position to 'APPEND'"), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"refresh").requires(src -> src.hasPermission(1))).executes(ctx -> CustomCommands.refreshDisplayNames((CommandContext<CommandSourceStack>)ctx, true)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(src -> src.hasPermission(3))).then(Commands.literal((String)"format").executes(ctx -> {
            Services.CONFIG.SetFormat(Services.CONFIG.BaseListFormat());
            CustomCommands.refreshDisplayNames((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Reset format back to default! (%s)".formatted(Services.CONFIG.BaseListFormat())), true);
            return 1;
        }))).then(Commands.literal((String)"color").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> {
            String dim = DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension").dimension().location().toString();
            Services.CONFIG.ResetColor(dim);
            CustomCommands.refreshDisplayNames((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Reset color for dimension: %s".formatted(dim)), true);
            return 1;
        })))).then(Commands.literal((String)"alias").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> {
            String dim = DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension").dimension().location().toString();
            Services.CONFIG.ResetAlias(dim);
            CustomCommands.refreshDisplayNames((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Reset alias for dimension: %s".formatted(dim)), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"custom_colors").then(Commands.literal((String)"get").executes(ctx -> {
            MutableComponent response = Component.empty();
            if (Services.CONFIG.GetAllCustomColors().size() == 0) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"No custom colors have been registered."), true);
                return 1;
            }
            response.append((Component)Component.literal((String)"Custom colors registered: "));
            int i = 0;
            for (String color : Services.CONFIG.GetAllCustomColors()) {
                String name = color.split(" ", 2)[0];
                String value = color.split(" ", 2)[1];
                response.append((Component)Component.literal((String)"%s (%s)".formatted(name, value)).withColor(CommonUtils.customColorToInt(color.split(" "))));
                if (i < Services.CONFIG.GetAllCustomColors().size() - 1) {
                    response.append(", ");
                }
                ++i;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> response, true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(src -> src.hasPermission(3))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"color", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            String color = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            if (Services.CONFIG.GetAllCustomColors().stream().anyMatch(c -> c.split(" ", 2)[0].equals(name))) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to add custom color. Color with name '%s' already exists!".formatted(name)));
                return 0;
            }
            if (color.matches("(?i)#[0-9a-f]{6}") || color.matches("r[0-9]{1,3} g[0-9]{1,3} b[0-9]{1,3}")) {
                Services.CONFIG.AddCustomColor(name.toUpperCase(Locale.ROOT), color);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successfully added new custom color!"), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to add custom color!\nColor needs to be in the form of '#123456' or 'r1 g23 b456'"));
            return 0;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(src -> src.hasPermission(3))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String color = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            if (Services.CONFIG.RemoveCustomColor(color)) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successfully removed color '%s'".formatted(color)), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Could not find custom color '%s' to remove".formatted(color)));
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(src -> src.hasPermission(3))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"custom_color", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String dim = DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension").dimension().location().toString();
            String color = StringArgumentType.getString((CommandContext)ctx, (String)"custom_color").toUpperCase();
            if (Services.CONFIG.GetAllCustomColors().stream().anyMatch(c -> c.split(" ", 2)[0].equals(color))) {
                Services.CONFIG.SetColor(dim, color);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successfully set dimension '%s' color to '%s'".formatted(dim, color)), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to find custom color with name '%s'".formatted(color)));
            return 0;
        }))))));
    }

    private static int setBoolSetting(CommandContext<CommandSourceStack> ctx, String perDimColor) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        Services.CONFIG.SetBoolSetting(perDimColor, value);
        CustomCommands.refreshDisplayNames(ctx);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Set option %s to '%s'".formatted(perDimColor, value)), true);
        return 1;
    }

    private static int getDimensionId(CommandContext<CommandSourceStack> context) {
        try {
            ResourceKey dim = ((CommandSourceStack)context.getSource()).getPlayerOrException().level().dimension();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(String.valueOf(dim.location()) + ": " + CommonUtils.dimensionToString(dim.location()))), true);
            return 1;
        }
        catch (CommandSyntaxException | NullPointerException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Failed to find player!"));
            return -1;
        }
    }

    private static int refreshDisplayNames(CommandContext<CommandSourceStack> context, boolean manuallyCalled) {
        Services.CONFIG.RefreshPlayerData(((CommandSourceStack)context.getSource()).getServer().getPlayerList());
        if (manuallyCalled) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Refreshing Dimension Viewer details!"), true);
        }
        return 1;
    }

    private static void refreshDisplayNames(CommandContext<CommandSourceStack> context) {
        CustomCommands.refreshDisplayNames(context, false);
    }
}

