/*
 * Decompiled with CFR 0.152.
 */
package dev.stick_stack.dimensionviewer;

import dev.stick_stack.dimensionviewer.CommonUtils;
import dev.stick_stack.dimensionviewer.ConfigCommon;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigNeoForge {
    private static final List<String> moddedDimensionList = new ArrayList<String>();
    private static final List<String> dimensionAliases = new ArrayList<String>();
    private static final List<String> customColourList = new ArrayList<String>();
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec CONFIG;
    public static ModConfigSpec.ConfigValue<String> LIST_FORMAT;
    public static ModConfigSpec.EnumValue<CommonUtils.DimensionPosition> DIM_POSITION;
    public static ModConfigSpec.ConfigValue<String> DEFAULT_COLOR;
    public static ModConfigSpec.ConfigValue<String> OVERWORLD_COLOR;
    public static ModConfigSpec.ConfigValue<String> NETHER_COLOR;
    public static ModConfigSpec.ConfigValue<String> END_COLOR;
    public static ModConfigSpec.BooleanValue PER_DIM_COLOR;
    public static ModConfigSpec.BooleanValue DIM_IN_CHAT_NAME;
    public static ModConfigSpec.BooleanValue CHAT_DIM_HOVER;
    public static ModConfigSpec.BooleanValue ENABLE_ALIASES;
    public static ModConfigSpec.ConfigValue<List<? extends String>> MODDED_DIMS;
    public static ModConfigSpec.ConfigValue<List<? extends String>> DIM_ALIASES;
    public static ModConfigSpec.ConfigValue<List<? extends String>> CUSTOM_COLORS;

    private static void CategoryCustomization() {
        LIST_FORMAT = BUILDER.comment(new String[]{"Format that will be used to display the dimension in the tab list with the use of tokens:", "    %d - Dimension Name*", "    %i - Italic font", "    %b - Bold font", "    %u - Underline font", "    %o - Obfuscated font", "    %s - Strikethrough font\n*Required (well, not technically, but it defeats the purpose without it!)"}).define("listFormat", (Object)ConfigCommon.DEFAULT_LIST_FORMAT);
        DIM_POSITION = BUILDER.comment("Whether the dimension should be placed before or after the player name").defineEnum("dimensionPosition", (Enum)CommonUtils.DimensionPosition.APPEND);
        DEFAULT_COLOR = BUILDER.comment(new String[]{"The color to use for the dimension font if perDimColorPath is false.", "(In the event of a modded dimension being entered, this color will be used as a fallback)"}).define("fontColor", (Object)ConfigCommon.DEFAULT_COLOR);
        PER_DIM_COLOR = BUILDER.comment("Should each dimension have its own color?").define("perDimColor", ConfigCommon.PER_DIM_COLOR);
        ENABLE_ALIASES = BUILDER.comment("Global toggle for dimension aliases. Requires aliases to be set below.").define("enableAliases", ConfigCommon.ENABLE_ALIASES);
        ConfigNeoForge.PerDimensionCustomization();
        ConfigNeoForge.ChatCustomization();
        ConfigNeoForge.ModdedDimensionCustomization();
        ConfigNeoForge.ExtraCustomization();
    }

    private static void PerDimensionCustomization() {
        BUILDER.comment("Per-Dimension Customization").push("dimension");
        OVERWORLD_COLOR = BUILDER.comment("Color to use for the Overworld\nAllowed Values: DARK_RED, RED, GOLD, YELLOW, DARK_GREEN, GREEN, AQUA, DARK_AQUA, DARK_BLUE, BLUE, LIGHT_PURPLE, DARK_PURPLE, WHITE, GRAY, DARK_GRAY, BLACK\nOr any custom colours defined in `customColors`").define("overworldColor", (Object)ConfigCommon.OVERWORLD_COLOR);
        NETHER_COLOR = BUILDER.comment("Color to use for the Nether\nAllowed Values: DARK_RED, RED, GOLD, YELLOW, DARK_GREEN, GREEN, AQUA, DARK_AQUA, DARK_BLUE, BLUE, LIGHT_PURPLE, DARK_PURPLE, WHITE, GRAY, DARK_GRAY, BLACK\nOr any custom colours defined in `customColors`").define("netherColor", (Object)ConfigCommon.NETHER_COLOR);
        END_COLOR = BUILDER.comment("Color to use for the End\nAllowed Values: DARK_RED, RED, GOLD, YELLOW, DARK_GREEN, GREEN, AQUA, DARK_AQUA, DARK_BLUE, BLUE, LIGHT_PURPLE, DARK_PURPLE, WHITE, GRAY, DARK_GRAY, BLACK\nOr any custom colours defined in `customColors`").define("endColor", (Object)ConfigCommon.END_COLOR);
        BUILDER.pop();
    }

    private static void ChatCustomization() {
        BUILDER.comment("Chat-related Customization").push("chat");
        DIM_IN_CHAT_NAME = BUILDER.comment("Should a users' current dimension be added to chat messages?").define("dimInChatName", ConfigCommon.DIM_IN_CHAT_NAME);
        CHAT_DIM_HOVER = BUILDER.comment(new String[]{"Add a hover effect in chat that will display the source of a dimension", "Requires `dimInChatName` to be set to true"}).define("chatDimHover", ConfigCommon.CHAT_DIM_HOVER);
        BUILDER.pop();
    }

    private static void ModdedDimensionCustomization() {
        BUILDER.comment("Modded Dimension Customization").push("modded");
        MODDED_DIMS = BUILDER.comment("A list of modded dimension resource IDs and a color in the format of \"modid:dim_id color\"\nFor example, Twilight Forest in Gold would be \"twilightforest:twilight_forest GOLD\"\nWill throw an exception if the color is not valid\nAllowed Values: DARK_RED, RED, GOLD, YELLOW, DARK_GREEN, GREEN, AQUA, DARK_AQUA, DARK_BLUE, BLUE, LIGHT_PURPLE, DARK_PURPLE, WHITE, GRAY, DARK_GRAY, BLACK\nOr any custom colours defined in `customColors`\nSupports Regex!").defineListAllowEmpty(List.of("moddedDimensions"), () -> moddedDimensionList, item -> {
            String i;
            return item instanceof String && (i = (String)item).matches("([a-z_]+:.+) ([A-Z_]+)");
        });
        DIM_ALIASES = BUILDER.comment("A list of aliases to use instead of the original dimension ID.\nUses the format 'modid:dim_id New Name'.\nFor example, to replace 'Overworld' with 'Grasslands' you would use 'minecraft:overworld Grasslands'\nAliases support the same tokens as `listFormat`, allowing you to make a specific dimension bold or italic or both!\nSupports Regex!").defineListAllowEmpty(List.of("dimensionAliases"), () -> dimensionAliases, item -> {
            String i;
            return item instanceof String && (i = (String)item).matches("([a-z_]+:.+) (.*)");
        });
        BUILDER.pop();
    }

    private static void ExtraCustomization() {
        BUILDER.comment("Extra Customization").push("extra");
        CUSTOM_COLORS = BUILDER.comment("Custom colors can be defined here.\nUses the format 'COLOR_NAME #HEX' or 'COLOR_NAME r000 g000 b000'\nIf a custom color of the same name already exists the server will reject the newest one.\nThe name must be uppercase and can only contain letters and underscores.").defineListAllowEmpty(List.of("customColors"), () -> customColourList, item -> {
            String i;
            return item instanceof String && (i = (String)item).matches("[A-Z_]+ (#(?:[0-9a-fA-F]{3}){1,2}|[rh][0-9]{1,3} [gs][0-9]{1,3} [bv][0-9]{1,3}[ ]?)") && customColourList.stream().noneMatch(p -> p.split(" ")[0].equals(i.split(" ")[0]));
        });
    }

    static {
        BUILDER.comment("Customization Settings").push("customization");
        ConfigNeoForge.CategoryCustomization();
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

