/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.world.FeatureMineralVein;
import blusunrize.immersiveengineering.common.world.IECountPlacement;
import blusunrize.immersiveengineering.common.world.IEHeightProvider;
import blusunrize.immersiveengineering.common.world.IEOreFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class IEWorldGen {
    private static final DeferredRegister<Feature<?>> FEATURE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.FEATURE, (String)"immersiveengineering");
    public static final DeferredHolder<Feature<?>, FeatureMineralVein> MINERAL_VEIN_FEATURE = FEATURE_REGISTER.register("mineral_vein", FeatureMineralVein::new);
    public static final DeferredHolder<Feature<?>, IEOreFeature> IE_CONFIG_ORE = FEATURE_REGISTER.register("ie_ore", IEOreFeature::new);
    private static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_REGISTER = DeferredRegister.create((ResourceKey)Registries.PLACEMENT_MODIFIER_TYPE, (String)"immersiveengineering");
    public static DeferredHolder<PlacementModifierType<?>, PlacementModifierType<IECountPlacement>> IE_COUNT_PLACEMENT = PLACEMENT_REGISTER.register("ie_count", () -> () -> IECountPlacement.CODEC);
    private static final DeferredRegister<HeightProviderType<?>> HEIGHT_REGISTER = DeferredRegister.create((ResourceKey)Registries.HEIGHT_PROVIDER_TYPE, (String)"immersiveengineering");
    public static DeferredHolder<HeightProviderType<?>, HeightProviderType<IEHeightProvider>> IE_HEIGHT_PROVIDER = HEIGHT_REGISTER.register("ie_range", () -> () -> IEHeightProvider.CODEC);
    private static volatile List<PlacedFeature> RETROGEN_FEATURES = List.of();
    public static final Map<ResourceKey<Level>, List<ChunkPos>> retrogenChunks = new HashMap<ResourceKey<Level>, List<ChunkPos>>();
    private static int indexToRemove = 0;

    public static void init(IEventBus modBus) {
        FEATURE_REGISTER.register(modBus);
        PLACEMENT_REGISTER.register(modBus);
        HEIGHT_REGISTER.register(modBus);
    }

    public static void onConfigUpdated() {
        ArrayList<PlacedFeature> enabledFeatures = new ArrayList<PlacedFeature>();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            Registry registry = server.registryAccess().registryOrThrow(Registries.PLACED_FEATURE);
            for (PlacedFeature feature : registry) {
                if (!IEWorldGen.isRetrogenFeature(feature)) continue;
                enabledFeatures.add(feature);
            }
        }
        RETROGEN_FEATURES = List.copyOf(enabledFeatures);
    }

    private static boolean isRetrogenFeature(PlacedFeature placed) {
        ConfiguredFeature feature = (ConfiguredFeature)placed.feature().value();
        FeatureConfiguration featureConfiguration = feature.config();
        if (featureConfiguration instanceof IEOreFeature.IEOreFeatureConfig) {
            IEOreFeature.IEOreFeatureConfig featureConfig = (IEOreFeature.IEOreFeatureConfig)featureConfiguration;
            return (Boolean)IEServerConfig.ORES.ores.get((Object)((Object)featureConfig.type())).retrogenEnabled.get();
        }
        if (feature.feature() instanceof FeatureMineralVein) {
            return (Boolean)IEServerConfig.ORES.retrogenExcavatorVeins.get();
        }
        return false;
    }

    private static void generateOres(RandomSource random, int chunkX, int chunkZ, ServerLevel world) {
        for (PlacedFeature placed : RETROGEN_FEATURES) {
            placed.place((WorldGenLevel)world, world.getChunkSource().getGenerator(), random, new BlockPos(16 * chunkX, 0, 16 * chunkZ));
        }
    }

    @SubscribeEvent
    public static void chunkDataSave(ChunkDataEvent.Save event) {
        CompoundTag levelTag = event.getData().getCompound("Level");
        CompoundTag nbt = new CompoundTag();
        levelTag.put("ImmersiveEngineering", (Tag)nbt);
        nbt.putBoolean((String)IEServerConfig.ORES.retrogen_key.get(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void chunkDataLoad(ChunkDataEvent.Load event) {
        if (RETROGEN_FEATURES.isEmpty()) {
            return;
        }
        LevelAccessor world = event.getLevel();
        if (event.getChunk().getPersistedStatus() != ChunkStatus.FULL || !(world instanceof Level)) {
            return;
        }
        if (event.getData().getCompound("ImmersiveEngineering").contains((String)IEServerConfig.ORES.retrogen_key.get())) {
            return;
        }
        if (((Boolean)IEServerConfig.ORES.retrogen_log_flagChunk.get()).booleanValue()) {
            IELogger.info("Chunk " + String.valueOf(event.getChunk().getPos()) + " has been flagged for Ore RetroGeneration by IE.");
        }
        ResourceKey dimension = ((Level)world).dimension();
        Map<ResourceKey<Level>, List<ChunkPos>> map = retrogenChunks;
        synchronized (map) {
            retrogenChunks.computeIfAbsent((ResourceKey<Level>)dimension, d -> new ArrayList()).add(event.getChunk().getPos());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void serverWorldTick(LevelTickEvent.Post event) {
        int remaining;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ResourceKey dimension = serverLevel.dimension();
        int counter = 0;
        Map<ResourceKey<Level>, List<ChunkPos>> map = retrogenChunks;
        synchronized (map) {
            List<ChunkPos> chunks = retrogenChunks.get(dimension);
            if (chunks != null && !chunks.isEmpty()) {
                if (indexToRemove >= chunks.size()) {
                    indexToRemove = 0;
                }
                for (int i = 0; i < 2 && indexToRemove < chunks.size() && chunks.size() > 0; ++i) {
                    ChunkPos loc = chunks.get(indexToRemove);
                    if (serverLevel.hasChunk(loc.x, loc.z)) {
                        long worldSeed = serverLevel.getSeed();
                        RandomSource fmlRandom = RandomSource.create((long)worldSeed);
                        long xSeed = fmlRandom.nextLong() >> 3;
                        long zSeed = fmlRandom.nextLong() >> 3;
                        fmlRandom.setSeed(xSeed * (long)loc.x + zSeed * (long)loc.z ^ worldSeed);
                        IEWorldGen.generateOres(fmlRandom, loc.x, loc.z, serverLevel);
                        ++counter;
                        chunks.remove(indexToRemove);
                        continue;
                    }
                    ++indexToRemove;
                }
            }
            remaining = chunks == null ? 0 : chunks.size();
        }
        if (counter > 0 && ((Boolean)IEServerConfig.ORES.retrogen_log_remaining.get()).booleanValue()) {
            IELogger.info("Retrogen was performed on " + counter + " Chunks, " + remaining + " chunks remaining");
        }
    }
}

