/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.items.SawbladeItem;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class GrindingDiskItem
extends SawbladeItem {
    private static final Set<ItemAbility> TOOL_ACTIONS = ImmutableSet.of((Object)ItemAbilities.PICKAXE_DIG, (Object)ItemAbilities.AXE_STRIP, (Object)ItemAbilities.AXE_SCRAPE, (Object)ItemAbilities.AXE_WAX_OFF, (Object)Lib.WIRECUTTER_DIG);
    private static final ListTag ENCHANTS = new ListTag();
    public static final ResourceLocation TEXTURE = ImmersiveEngineering.rl("item/grindingdisk_blade");

    public GrindingDiskItem(int maxDamage, float sawbladeSpeed, float sawbladeDamage) {
        super(maxDamage, sawbladeSpeed, sawbladeDamage, TEXTURE);
    }

    @Override
    public int getSawbladeDamageFromBlock(boolean effective) {
        return effective ? 1 : 10;
    }

    @Override
    public boolean canSawbladeFellTree() {
        return false;
    }

    @Override
    public Map<ResourceKey<Enchantment>, Integer> getExtraEnchantments() {
        return Map.of(Enchantments.SILK_TOUCH, 1);
    }

    @Override
    public Predicate<BlockState> getSawbladeMaterials() {
        return s -> s.is(IETags.grindingDiskHarvestable);
    }

    @Override
    public Set<ItemAbility> getItemAbilities() {
        return TOOL_ACTIONS;
    }

    static {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", "silk_touch");
        tag.putInt("lvl", 1);
        ENCHANTS.add((Object)tag);
    }
}

