/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import blusunrize.immersiveengineering.common.items.PotionBucketItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import malte0811.dualcodecs.DualCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class PotionFluid
extends Fluid {
    public static FluidStack getFluidStackForType(Optional<Holder<Potion>> type, int amount, PotionBottleType bottleType) {
        if (type.isEmpty() || type.get().is(Potions.WATER)) {
            return new FluidStack((Fluid)Fluids.WATER, amount);
        }
        FluidStack stack = new FluidStack((Fluid)IEFluids.POTION.get(), amount);
        stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(type.get()));
        stack.set(IEDataComponents.POTION_BOTTLE_TYPE, (Object)bottleType);
        return stack;
    }

    public static Holder<Potion> getType(FluidStack stack) {
        return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER))).potion().orElse(Potions.WATER);
    }

    @Nonnull
    public Item getBucket() {
        return IEItems.Misc.POTION_BUCKET.get();
    }

    protected boolean canBeReplacedWith(@Nonnull FluidState fluidState, @Nonnull BlockGetter blockReader, @Nonnull BlockPos pos, @Nonnull Fluid fluid, @Nonnull Direction direction) {
        return true;
    }

    @Nonnull
    protected Vec3 getFlow(@Nonnull BlockGetter blockReader, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        return Vec3.ZERO;
    }

    public int getTickDelay(LevelReader p_205569_1_) {
        return 0;
    }

    protected float getExplosionResistance() {
        return 0.0f;
    }

    public float getHeight(@Nonnull FluidState p_215662_1_, @Nonnull BlockGetter p_215662_2_, @Nonnull BlockPos p_215662_3_) {
        return 0.0f;
    }

    public float getOwnHeight(@Nonnull FluidState p_223407_1_) {
        return 0.0f;
    }

    @Nonnull
    protected BlockState createLegacyBlock(@Nonnull FluidState state) {
        return Blocks.AIR.defaultBlockState();
    }

    public boolean isSource(@Nonnull FluidState state) {
        return true;
    }

    public int getAmount(@Nonnull FluidState state) {
        return 0;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull FluidState p_215664_1_, @Nonnull BlockGetter p_215664_2_, @Nonnull BlockPos p_215664_3_) {
        return Shapes.empty();
    }

    @Nonnull
    public FluidType getFluidType() {
        return (FluidType)IEFluids.POTION_TYPE.value();
    }

    public void addInformation(FluidStack fluidStack, Consumer<Component> tooltip) {
        PotionContents potionData = (PotionContents)fluidStack.get(DataComponents.POTION_CONTENTS);
        if (potionData == null) {
            return;
        }
        ArrayList effects = new ArrayList();
        potionData.forEachEffect(effects::add);
        if (effects.isEmpty()) {
            tooltip.accept((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance instance : effects) {
                MutableComponent itextcomponent = Component.translatable((String)instance.getDescriptionId());
                MobEffect effect = (MobEffect)instance.getEffect().value();
                if (instance.getAmplifier() > 0) {
                    itextcomponent.append(" ").append((Component)Component.translatable((String)("potion.potency." + instance.getAmplifier())));
                }
                if (instance.getDuration() > 20) {
                    itextcomponent.append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)1.0f, (float)20.0f)).append(")");
                }
                tooltip.accept((Component)itextcomponent.withStyle(effect.getCategory().getTooltipFormatting()));
            }
        }
        if (potionData.potion().isPresent()) {
            String modID = ((ResourceKey)((Holder)potionData.potion().get()).unwrapKey().orElseThrow()).location().getNamespace();
            tooltip.accept((Component)Component.translatable((String)"desc.immersiveengineering.info.potionMod", (Object[])new Object[]{Utils.getModName(modID)}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public static enum PotionBottleType implements StringRepresentable
    {
        REGULAR(Items.POTION),
        SPLASH(Items.SPLASH_POTION),
        LINGERING(Items.LINGERING_POTION);

        private final Item bottleItem;
        public static final DualCodec<ByteBuf, PotionBottleType> CODEC;

        private PotionBottleType(Item bottleItem) {
            this.bottleItem = bottleItem;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static PotionBottleType fromItem(Holder<Item> item) {
            if (item.value() == Items.LINGERING_POTION) {
                return LINGERING;
            }
            if (item.value() == Items.SPLASH_POTION) {
                return SPLASH;
            }
            return REGULAR;
        }

        public Item getBottleItem() {
            return this.bottleItem;
        }

        static {
            CODEC = IEDualCodecs.forEnum((Enum[])PotionBottleType.values());
        }
    }

    public static class PotionFluidType
    extends FluidType {
        public static final ResourceLocation TEXTURE_STILL = ImmersiveEngineering.rl("block/fluid/potion_still");
        public static final ResourceLocation TEXTURE_FLOW = ImmersiveEngineering.rl("block/fluid/potion_flow");

        public PotionFluidType() {
            super(FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).density(1300));
        }

        public Component getDescription(FluidStack stack) {
            PotionContents potionData = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            PotionBottleType s = (PotionBottleType)((Object)stack.getOrDefault(IEDataComponents.POTION_BOTTLE_TYPE, (Object)PotionBottleType.REGULAR));
            return Component.translatable((String)Potion.getName((Optional)potionData.potion(), (String)(s.getBottleItem().getDescriptionId() + ".effect.")));
        }

        public ItemStack getBucket(FluidStack stack) {
            return PotionBucketItem.forPotion(PotionFluid.getType(stack));
        }
    }
}

