/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FurnaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.NonMirrorableWithActiveBlock;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class AlloySmelterLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State> {
    public static final int NUM_SLOTS = 4;

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        IMultiblockLevel level = context.getLevel();
        Boolean wasActive = (Boolean)level.getBlockState(IEMultiblocks.ALLOY_SMELTER.getMasterFromOriginOffset()).getValue(NonMirrorableWithActiveBlock.ACTIVE);
        boolean active = context.getState().furnace.tickServer(context);
        if (active != wasActive) {
            NonMirrorableWithActiveBlock.setActive(level, IEMultiblocks.ALLOY_SMELTER, active);
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return $ -> Shapes.block();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems(state.inventory, drop);
    }

    public static class State
    implements IMultiblockState,
    FurnaceHandler.IFurnaceEnvironment<AlloyRecipe> {
        private final SlotwiseItemHandler inventory;
        private final FurnaceHandler<AlloyRecipe> furnace;
        private final Supplier<AlloyRecipe> cachedRecipe;

        public State(IInitialMultiblockContext<State> ctx) {
            this.furnace = new FurnaceHandler<AlloyRecipe>(2, List.of(new FurnaceHandler.InputSlot<AlloyRecipe>(a -> a.input0, 0), new FurnaceHandler.InputSlot<AlloyRecipe>(a -> a.input1, 1)), List.of(new FurnaceHandler.OutputSlot<AlloyRecipe>(a -> a.output, 3)), a -> a.time, ctx.getMarkDirtyRunnable());
            this.inventory = new SlotwiseItemHandler(List.of(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, new SlotwiseItemHandler.IOConstraint(true, AbstractFurnaceBlockEntity::isFuel), SlotwiseItemHandler.IOConstraint.OUTPUT), ctx.getMarkDirtyRunnable());
            this.cachedRecipe = CachedRecipe.cached(AlloyRecipe::findRecipe, ctx.levelSupplier(), () -> this.inventory.getStackInSlot(0), () -> this.inventory.getStackInSlot(1));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("inventory", this.inventory.serializeNBT(provider));
            nbt.put("furnace", this.furnace.toNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.furnace.readNBT(nbt.get("furnace"));
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory;
        }

        @Override
        @Nullable
        public AlloyRecipe getRecipeForInput() {
            return this.cachedRecipe.get();
        }

        @Override
        public int getBurnTimeOf(Level level, ItemStack fuel) {
            return fuel.getBurnTime(RecipeType.SMELTING);
        }

        public ContainerData getStateView() {
            return this.furnace.stateView;
        }
    }
}

