/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockContext;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public record InitialMultiblockContext<State extends IMultiblockState>(BlockEntity masterBE, MultiblockOrientation orientation, BlockPos masterOffset) implements IInitialMultiblockContext<State>
{
    @Override
    public <T, C> Supplier<T> getCapabilityAt(BlockCapability<T, C> capability, BlockPos posRelativeToMB, C context) {
        return InitialMultiblockContext.getCapabilityAt(this.masterBE, this.orientation, this.masterOffset, capability, posRelativeToMB, context);
    }

    @Override
    public <T> Supplier<T> getCapabilityAt(BlockCapability<T, Direction> capability, BlockPos posRelativeToMB, RelativeBlockFace face) {
        return this.getCapabilityAt(capability, posRelativeToMB, face.forFront(this.orientation));
    }

    @Override
    public Supplier<@Nullable Level> levelSupplier() {
        return () -> ((BlockEntity)this.masterBE).getLevel();
    }

    @Override
    public Runnable getMarkDirtyRunnable() {
        return () -> ((BlockEntity)this.masterBE).setChanged();
    }

    @Override
    public Runnable getSyncRunnable() {
        return () -> MultiblockContext.requestBESync(this.masterBE);
    }

    @Override
    public Runnable getBlockUpdateRunnable() {
        return () -> {
            Level level = this.masterBE.getLevel();
            if (level == null) {
                return;
            }
            BlockState state = this.masterBE.getBlockState();
            level.sendBlockUpdated(this.masterBE.getBlockPos(), state, state, 3);
            level.updateNeighborsAt(this.masterBE.getBlockPos(), state.getBlock());
        };
    }

    public static <T, C> Supplier<@Nullable T> getCapabilityAt(final BlockEntity masterBE, final MultiblockOrientation orientation, final BlockPos masterOffset, final BlockCapability<T, C> capability, final BlockPos posRelativeToMB, final C context) {
        return new Supplier<T>(){
            private BlockCapabilityCache<T, C> cache;

            @Override
            @Nullable
            public T get() {
                Level level = masterBE.getLevel();
                if (level == null) {
                    return null;
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.cache == null) {
                        this.cache = BlockCapabilityCache.create((BlockCapability)capability, (ServerLevel)serverLevel, (BlockPos)this.getCapabilityPos(), (Object)context);
                    }
                    return this.cache.getCapability();
                }
                return level.getCapability(capability, this.getCapabilityPos(), context);
            }

            private BlockPos getCapabilityPos() {
                BlockPos offset = orientation.getAbsoluteOffset(posRelativeToMB.subtract((Vec3i)masterOffset));
                return masterBE.getBlockPos().offset((Vec3i)offset);
            }
        };
    }
}

