/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.PostTransformerBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PostTransformerBlock
extends ConnectorBlock<PostTransformerBlockEntity> {
    public PostTransformerBlock(BlockBehaviour.Properties props) {
        super(props, IEBlockEntities.POST_TRANSFORMER);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_HORIZONTAL, BlockStateProperties.WATERLOGGED});
    }

    public Item asItem() {
        return IEBlocks.Connectors.TRANSFORMER.get().asItem();
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState baseState = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return this.stateForPos(baseState, currentPos, (BlockGetter)worldIn, Blocks.AIR.defaultBlockState());
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState baseState = super.getStateForPlacement(context);
        return this.stateForPos(baseState, context.getClickedPos(), (BlockGetter)context.getLevel(), null);
    }

    private BlockState stateForPos(@Nullable BlockState baseState, BlockPos pos, BlockGetter world, BlockState empty) {
        if (baseState == null || baseState.getBlock() != this) {
            return empty;
        }
        Direction preferred = (Direction)baseState.getValue((Property)IEProperties.FACING_HORIZONTAL);
        Optional<Direction> newFacing = PostTransformerBlock.findAttacheablePost(pos, world, preferred);
        if (newFacing.isPresent()) {
            return (BlockState)baseState.setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)newFacing.get());
        }
        return empty;
    }

    private static Optional<Direction> findAttacheablePost(BlockPos transformerPos, BlockGetter world, Direction preferred) {
        Optional<Direction> ret = Optional.empty();
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            if (!PostTransformerBlock.isAttacheablePost(transformerPos.relative(d), world)) continue;
            ret = Optional.of(d);
            if (d == preferred) break;
        }
        return ret;
    }

    public static boolean isAttacheablePost(BlockPos possiblePost, BlockGetter w) {
        BlockState postState = w.getBlockState(possiblePost);
        if (!(postState.getBlock() instanceof IPostBlock)) {
            return false;
        }
        IPostBlock post = (IPostBlock)postState.getBlock();
        return post.canConnectTransformer(w, possiblePost);
    }
}

