/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.orientation.RotationUtil;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MetalLadderBlock
extends LadderBlock
implements IEBlockInterfaces.IHammerBlockInteraction {
    public static final BooleanProperty OPEN;
    private static final Map<Direction, VoxelShape> FRAMES;
    private static final Map<Direction, VoxelShape> FRAMES_OPEN;
    private final CoverType type;

    private static VoxelShape merge(VoxelShape a, AABB b) {
        return Shapes.joinUnoptimized((VoxelShape)a, (VoxelShape)Shapes.create((AABB)b), (BooleanOp)BooleanOp.OR);
    }

    public MetalLadderBlock(CoverType type, BlockBehaviour.Properties props) {
        super(props);
        this.type = type;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        VoxelShape base = super.getShape(state, world, pos, ctx);
        if (this.type == CoverType.NONE) {
            return base;
        }
        Direction ladderSide = (Direction)state.getValue((Property)LadderBlock.FACING);
        return (Boolean)state.getValue((Property)OPEN) != false ? Shapes.joinUnoptimized((VoxelShape)base, (VoxelShape)FRAMES_OPEN.get(ladderSide), (BooleanOp)BooleanOp.OR) : Shapes.joinUnoptimized((VoxelShape)base, (VoxelShape)FRAMES.get(ladderSide), (BooleanOp)BooleanOp.OR);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState baseState = super.getStateForPlacement(ctx);
        if (baseState == null) {
            return baseState;
        }
        baseState = (BlockState)baseState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
        if (this.type == CoverType.NONE) {
            return baseState;
        }
        return (BlockState)baseState.setValue((Property)LadderBlock.FACING, (Comparable)Direction.fromYRot((double)ctx.getRotation()).getOpposite());
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (this.type == CoverType.NONE) {
            return super.canSurvive(state, world, pos);
        }
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING, WATERLOGGED, OPEN});
    }

    @Override
    public InteractionResult useHammer(BlockState state, Level world, BlockPos pos, Player player, UseOnContext context) {
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (this.type != CoverType.NONE && player.isShiftKeyDown()) {
            boolean b = world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)OPEN) == false)));
            if (b) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (RotationUtil.rotateBlock(world, pos, false)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    static {
        VoxelShape forDir;
        OPEN = BooleanProperty.create((String)"open");
        FRAMES = new EnumMap<Direction, VoxelShape>(Direction.class);
        FRAMES_OPEN = new EnumMap<Direction, VoxelShape>(Direction.class);
        for (Direction dir : DirectionUtils.BY_HORIZONTAL_INDEX) {
            forDir = Shapes.empty();
            if (dir != Direction.NORTH) {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
            }
            if (dir != Direction.EAST) {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
            }
            if (dir != Direction.SOUTH) {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
            }
            if (dir != Direction.WEST) {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0));
            }
            FRAMES.put(dir, forDir);
        }
        for (Direction dir : DirectionUtils.BY_HORIZONTAL_INDEX) {
            forDir = Shapes.empty();
            if (dir.getAxis() == Direction.Axis.Z) {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0));
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
            } else {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
            }
            FRAMES_OPEN.put(dir, forDir);
        }
    }

    public static enum CoverType {
        NONE,
        ALU,
        STEEL;

    }
}

