/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.energy.NullEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class DynamoBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional {
    private final IRotationAcceptor rotationCap = new RotationAcceptor();
    private final Map<Direction, IEBlockCapabilityCaches.IEBlockCapabilityCache<IEnergyStorage>> neighbors = IEBlockCapabilityCaches.allNeighbors(Capabilities.EnergyStorage.BLOCK, this);

    public DynamoBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.DYNAMO.get(), pos, state);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<DynamoBlockEntity> registrar) {
        registrar.registerAllContexts(Capabilities.EnergyStorage.BLOCK, $ -> NullEnergyStorage.INSTANCE);
        registrar.register(IRotationAcceptor.CAPABILITY, (be, side) -> side == be.getFacing() ? be.rotationCap : null);
    }

    private class RotationAcceptor
    implements IRotationAcceptor {
        private RotationAcceptor() {
        }

        @Override
        public void inputRotation(double rotation) {
            int output = (int)((Double)IEServerConfig.MACHINES.dynamo_output.get() / 3.0 * rotation);
            for (IEBlockCapabilityCaches.IEBlockCapabilityCache<IEnergyStorage> neighbor : DynamoBlockEntity.this.neighbors.values()) {
                IEnergyStorage capOnSide = neighbor.getCapability();
                if (capOnSide != null) {
                    output -= capOnSide.receiveEnergy(output, false);
                }
                if (output > 0) continue;
                break;
            }
        }
    }
}

