/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.assembler.AssemblerHandler;
import blusunrize.immersiveengineering.api.tool.assembler.RecipeQuery;
import blusunrize.immersiveengineering.common.util.InventoryCraftingFalse;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;

public class CrafterPatternInventory {
    private static final int NUM_SLOTS = 10;
    public final NonNullList<ItemStack> inv = NonNullList.withSize((int)10, (Object)ItemStack.EMPTY);
    public Recipe<CraftingInput> recipe;

    public void recalculateOutput(@Nullable Level level) {
        if (level == null) {
            return;
        }
        CraftingInput invC = InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
        this.recipe = Utils.findCraftingRecipe(invC, level).map(RecipeHolder::value).orElse(null);
        this.inv.set(9, (Object)(this.recipe != null ? this.recipe.assemble((RecipeInput)invC, (HolderLookup.Provider)level.registryAccess()) : ItemStack.EMPTY));
    }

    public ListTag writeToNBT(HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.inv.size(); ++i) {
            if (((ItemStack)this.inv.get(i)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)i);
            list.add((Object)((ItemStack)this.inv.get(i)).save(provider, (Tag)itemTag));
        }
        return list;
    }

    public void readFromNBT(ListTag list, HolderLookup.Provider provider) {
        Collections.fill(this.inv, ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemTag = list.getCompound(i);
            int slot = itemTag.getByte("Slot") & 0xFF;
            if (slot >= 10) continue;
            this.inv.set(slot, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTag));
        }
    }

    @Nullable
    public List<RecipeQuery> getQueries(Level level) {
        if (this.recipe == null) {
            this.recalculateOutput(level);
        }
        if (this.recipe == null) {
            return null;
        }
        return CrafterPatternInventory.getQueriesGeneric(this.recipe, this.inv, level);
    }

    @Nullable
    private static <R extends Recipe<CraftingInput>> List<RecipeQuery> getQueriesGeneric(R recipe, NonNullList<ItemStack> inv, Level level) {
        AssemblerHandler.IRecipeAdapter<R> adapter = AssemblerHandler.findAdapter(recipe);
        return adapter.getQueriedInputs(recipe, inv, level);
    }
}

