/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Vector3f;

public class ChargingStationBlockEntity
extends IEBaseBlockEntity
implements IEClientTickableBE,
IEServerTickableBE,
IIEInventory,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IPlayerInteraction {
    public AveragingEnergyStorage energyStorage = new AveragingEnergyStorage(32000);
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private boolean charging = true;
    public int comparatorOutput = 0;
    private final IEnergyStorage energyCap = this.makeEnergyInput(this.energyStorage);
    private final IItemHandler insertionHandler = new IEInventoryHandler(1, this);

    public ChargingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CHARGING_STATION.get(), pos, state);
    }

    @Override
    public void tickClient() {
        IEnergyStorage itemEnergy = (IEnergyStorage)((ItemStack)this.inventory.get(0)).getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergy != null && this.charging) {
            float charge = 0.0f;
            float max = itemEnergy.getMaxEnergyStored();
            if (max > 0.0f) {
                charge = (float)itemEnergy.getEnergyStored() / max;
            }
            for (int i = 0; i < 3; ++i) {
                long time = this.level.getGameTime();
                if (!(charge >= 1.0f) && (time % 12L < (long)(i * 4) || time % 12L > (long)(i * 4 + 2))) continue;
                int shift = i - 1;
                double x = (double)this.getBlockPos().getX() + 0.5 + (this.getFacing() == Direction.WEST ? -0.46875 : (this.getFacing() == Direction.EAST ? 0.46875 : (this.getFacing() == Direction.NORTH ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                double y = (double)this.getBlockPos().getY() + 0.25;
                double z = (double)this.getBlockPos().getZ() + 0.5 + (this.getFacing() == Direction.NORTH ? -0.46875 : (this.getFacing() == Direction.SOUTH ? 0.46875 : (this.getFacing() == Direction.EAST ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                this.level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f - charge, charge, 0.0f), 0.5f), x, y, z, 0.25, 0.25, 0.25);
            }
        }
    }

    @Override
    public void tickServer() {
        this.energyStorage.updateAverage();
        IEnergyStorage itemEnergy = (IEnergyStorage)((ItemStack)this.inventory.get(0)).getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergy != null) {
            if (this.charging) {
                if (this.energyStorage.getEnergyStored() == 0) {
                    this.charging = false;
                    this.markContainingBlockForUpdate(null);
                    return;
                }
                int stored = itemEnergy.getEnergyStored();
                int max = itemEnergy.getMaxEnergyStored();
                int space = max - stored;
                if (space > 0) {
                    int energyDecNew;
                    int energyDec = 10 * stored / max;
                    int insert = Math.min(space, Math.max(this.energyStorage.getAverageInsertion(), (Integer)IEServerConfig.MACHINES.charger_consumption.get()));
                    int accepted = Math.min(itemEnergy.receiveEnergy(insert, true), this.energyStorage.extractEnergy(insert, true));
                    if ((accepted = this.energyStorage.extractEnergy(accepted, false)) > 0) {
                        stored += itemEnergy.receiveEnergy(accepted, false);
                    }
                    if (energyDec != (energyDecNew = 10 * stored / max)) {
                        this.markContainingBlockForUpdate(null);
                    }
                }
            } else if ((double)this.energyStorage.getEnergyStored() >= (double)this.energyStorage.getMaxEnergyStored() * 0.95) {
                this.charging = true;
                this.markContainingBlockForUpdate(null);
            }
        }
        if (this.level.getGameTime() % 32L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 0x1F)) {
            int i;
            float max;
            float charge = 0.0f;
            if (itemEnergy != null && (max = (float)itemEnergy.getMaxEnergyStored()) > 0.0f) {
                charge = (float)itemEnergy.getEnergyStored() / max;
            }
            if ((i = (int)(15.0f * charge)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        EnergyHelper.deserializeFrom(this.energyStorage, nbt, provider);
        this.inventory.set(0, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("inventory")));
        this.charging = nbt.getBoolean("charging");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        EnergyHelper.serializeTo(this.energyStorage, nbt, provider);
        nbt.putBoolean("charging", this.charging);
        if (!((ItemStack)this.inventory.get(0)).isEmpty()) {
            nbt.put("inventory", ((ItemStack)this.inventory.get(0)).saveOptional(provider));
        }
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return Shapes.box((double)(this.getFacing().getAxis() == Direction.Axis.X ? 0.0 : 0.125), (double)0.0, (double)(this.getFacing().getAxis() == Direction.Axis.Z ? 0.0 : 0.125), (double)(this.getFacing().getAxis() == Direction.Axis.X ? 1.0 : 0.875), (double)1.0, (double)(this.getFacing().getAxis() == Direction.Axis.Z ? 1.0 : 0.875));
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return EnergyHelper.isFluxReceiver(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public void doGraphicalUpdates() {
        this.setChanged();
        this.markContainingBlockForUpdate(null);
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<ChargingStationBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, facing) -> {
            if (facing == null || facing == Direction.DOWN || facing == be.getFacing().getOpposite()) {
                return be.energyCap;
            }
            return null;
        });
        registrar.register(Capabilities.ItemHandler.BLOCK, (be, facing) -> be.insertionHandler);
    }

    @Override
    public ItemInteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.isStackValid(0, heldItem)) {
            ItemStack stored = !((ItemStack)this.inventory.get(0)).isEmpty() ? ((ItemStack)this.inventory.get(0)).copy() : ItemStack.EMPTY;
            this.inventory.set(0, (Object)heldItem.copy());
            player.setItemInHand(hand, stored);
            this.setChanged();
            this.markContainingBlockForUpdate(null);
            return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        if (!((ItemStack)this.inventory.get(0)).isEmpty()) {
            if (!this.level.isClientSide) {
                player.spawnAtLocation(((ItemStack)this.inventory.get(0)).copy(), 0.5f);
            }
            this.inventory.set(0, (Object)ItemStack.EMPTY);
            this.setChanged();
            this.markContainingBlockForUpdate(null);
            return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

