/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.SiloLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionf;

public class SiloRenderer
extends IEMultiblockRenderer<SiloLogic.State> {
    @Override
    public void render(IMultiblockContext<SiloLogic.State> context, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        SiloLogic.State state = context.getState();
        if (state.identStack.isEmpty()) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 5.0, 0.5);
        float baseScale = 0.0625f;
        float itemScale = 0.5f;
        float flatScale = 0.001f;
        float textScale = 0.28125f;
        matrixStack.scale(baseScale, baseScale, baseScale);
        String label = "" + state.storageAmount;
        float w = ClientUtils.mc().font.width(label);
        float zz = 1.501f;
        zz /= baseScale;
        w *= textScale;
        for (int i = 0; i < 4; ++i) {
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 0.0f, zz);
            matrixStack.pushPose();
            matrixStack.last().pose().scale(itemScale / baseScale, itemScale / baseScale, flatScale);
            matrixStack.translate(0.0, -0.75, 0.0);
            ClientUtils.mc().getItemRenderer().renderStatic(state.identStack, ItemDisplayContext.GUI, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, context.getLevel().getRawLevel(), 0);
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.translate(-w / 2.0f, -11.0f, 0.001f);
            matrixStack.scale(textScale, -textScale, 1.0f);
            ClientUtils.font().drawInBatch(label, 0.0f, 0.0f, 0x888888, true, matrixStack.last().pose(), bufferIn, Font.DisplayMode.NORMAL, 0, combinedLightIn);
            matrixStack.popPose();
            matrixStack.popPose();
            matrixStack.mulPose(new Quaternionf().rotateY(1.5707964f));
        }
        matrixStack.popPose();
    }
}

