/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.SheetmetalTankLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class SheetmetalTankRenderer
extends IEMultiblockRenderer<SheetmetalTankLogic.State> {
    @Override
    public void render(IMultiblockContext<SheetmetalTankLogic.State> context, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        SheetmetalTankLogic.State state = context.getState();
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.0, 0.5);
        FluidStack fs = state.tank.getFluid();
        matrixStack.translate(0.0f, 3.5f, 0.0f);
        float baseScale = 0.0625f;
        matrixStack.scale(baseScale, -baseScale, baseScale);
        float xx = -0.5f;
        float zz = 1.496f;
        xx /= baseScale;
        zz /= baseScale;
        for (int i = 0; i < 4; ++i) {
            matrixStack.pushPose();
            matrixStack.translate(xx, 0.0f, zz);
            Matrix4f mat = matrixStack.last().pose();
            VertexConsumer builder = bufferIn.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
            builder.addVertex(mat, -4.0f, -4.0f, 0.0f).setColor(34, 34, 34, 255);
            builder.addVertex(mat, -4.0f, 20.0f, 0.0f).setColor(34, 34, 34, 255);
            builder.addVertex(mat, 20.0f, 20.0f, 0.0f).setColor(34, 34, 34, 255);
            builder.addVertex(mat, 20.0f, -4.0f, 0.0f).setColor(34, 34, 34, 255);
            if (!fs.isEmpty()) {
                float h = (float)fs.getAmount() / (float)state.tank.getCapacity();
                matrixStack.translate(0.0f, 0.0f, 0.004f);
                GuiHelper.drawRepeatedFluidSprite(bufferIn.getBuffer(RenderType.solid()), matrixStack, fs, 0.0f, 0.0f + (1.0f - h) * 16.0f, 16.0f, h * 16.0f);
            }
            matrixStack.popPose();
            matrixStack.mulPose(new Quaternionf().rotateY(1.5707964f));
        }
        matrixStack.popPose();
    }
}

