/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill.SawmillLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill.SawmillProcess;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class SawmillRenderer
extends IEMultiblockRenderer<SawmillLogic.State> {
    public static final String NAME = "sawmill_blade";
    public static DynamicModel BLADE;

    @Override
    public void render(IMultiblockContext<SawmillLogic.State> ctx, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        boolean sawblade;
        IMultiblockLevel level = ctx.getLevel();
        SawmillLogic.State state = ctx.getState();
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.0, 0.5);
        bufferIn = BERenderUtils.mirror(level.getOrientation(), matrixStack, bufferIn);
        VertexConsumer solidBuilder = bufferIn.getBuffer(RenderType.solid());
        Direction facing = level.getOrientation().front();
        float dir = facing == Direction.SOUTH ? (float)Math.PI : (facing == Direction.NORTH ? 0.0f : (facing == Direction.EAST ? -1.5707964f : 1.5707964f));
        matrixStack.mulPose(new Quaternionf().rotateY(dir));
        boolean bl = sawblade = !state.sawblade.isEmpty();
        if (sawblade) {
            matrixStack.pushPose();
            matrixStack.translate(1.0, 0.125, -0.5);
            float spin = state.animation_bladeRotation;
            if (state.active != SawmillLogic.ActiveState.NOT_RUNNING) {
                spin += 36.0f * partialTicks;
            }
            matrixStack.mulPose(new Quaternionf().rotateZ(spin * ((float)Math.PI / 180)));
            RenderUtils.renderModelTESRFast(BLADE.getNullQuads(), solidBuilder, matrixStack, combinedLightIn, combinedOverlayIn);
            matrixStack.popPose();
        }
        for (SawmillProcess process : state.sawmillProcessQueue) {
            float relative = process.getRelativeProcessStep(level.getRawLevel());
            ItemStack rendered = process.getCurrentStack(level.getRawLevel(), sawblade);
            this.renderItem(rendered, relative, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, level.getRawLevel());
        }
        matrixStack.popPose();
    }

    private void renderItem(ItemStack stack, float progress, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Level level) {
        float xOffset = -2.5f + progress * 5.0f;
        matrixStack.pushPose();
        matrixStack.translate((double)xOffset, 0.375, 0.0);
        matrixStack.mulPose(new Quaternionf().rotateZ(1.5707964f));
        ClientUtils.mc().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, level, 0);
        matrixStack.popPose();
    }
}

