/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.MetalPressLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class MetalPressRenderer
extends IEMultiblockRenderer<MetalPressLogic.State> {
    public static final String NAME = "metal_press_piston";
    public static DynamicModel PISTON;

    @Override
    public void render(IMultiblockContext<MetalPressLogic.State> ctx, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        MetalPressLogic.State state = ctx.getState();
        float piston = 0.0f;
        float[] shift = new float[state.processor.getQueueSize()];
        Level level = ctx.getLevel().getRawLevel();
        for (int i = 0; i < shift.length; ++i) {
            MultiblockProcess<MetalPressRecipe, ProcessContext.ProcessContextInWorld<MetalPressRecipe>> process = state.processor.getQueue().get(i);
            float processMaxTicks = process.getMaxTicks(level);
            float transportTime = MetalPressLogic.getTransportTime(processMaxTicks);
            float pressTime = MetalPressLogic.getPressTime(processMaxTicks);
            float fProcess = process.processTick;
            shift[i] = fProcess < transportTime ? 0.5f * fProcess / transportTime : (fProcess < processMaxTicks - transportTime ? 0.5f : 0.5f + 0.5f * (fProcess - (processMaxTicks - transportTime)) / transportTime);
            if (state.mold.isEmpty() || !(fProcess >= transportTime) || !(fProcess < processMaxTicks - transportTime)) continue;
            piston = fProcess < transportTime + pressTime ? (fProcess - transportTime) / pressTime : (fProcess < processMaxTicks - transportTime - pressTime ? 1.0f : 1.0f - (fProcess - (processMaxTicks - transportTime - pressTime)) / pressTime);
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        MultiblockOrientation orientation = ctx.getLevel().getOrientation();
        Direction effectiveFacing = orientation.mirrored() ? orientation.front().getOpposite() : orientation.front();
        MetalPressRenderer.rotateForFacingNoCentering(matrixStack, effectiveFacing);
        matrixStack.pushPose();
        matrixStack.translate(0.0f, -piston * 0.6875f, 0.0f);
        matrixStack.pushPose();
        matrixStack.translate(-0.5, -0.5, -0.5);
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BakedModel pistonModel = PISTON.get();
        blockRenderer.getModelRenderer().renderModel(matrixStack.last(), bufferIn.getBuffer(RenderType.solid()), null, pistonModel, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.solid());
        matrixStack.popPose();
        if (!state.mold.isEmpty()) {
            matrixStack.translate(0.0, 0.34, 0.0);
            matrixStack.mulPose(new Quaternionf().rotateX(-1.5707964f));
            float scale = 0.75f;
            matrixStack.scale(scale, scale, 1.0f);
            ClientUtils.mc().getItemRenderer().renderStatic(state.mold, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, level, 0);
        }
        matrixStack.popPose();
        matrixStack.translate(-1.25, -0.35, 0.0);
        for (int i = 0; i < shift.length; ++i) {
            MultiblockProcessInWorld inWorld;
            List<ItemStack> displays;
            MultiblockProcess<MetalPressRecipe, ProcessContext.ProcessContextInWorld<MetalPressRecipe>> process = state.processor.getQueue().get(i);
            if (!(process instanceof MultiblockProcessInWorld) || (displays = (inWorld = (MultiblockProcessInWorld)process).getDisplayItem(level)).isEmpty()) continue;
            matrixStack.pushPose();
            matrixStack.translate(2.5f * shift[i], 0.0f, 0.0f);
            if ((double)piston > 0.92) {
                matrixStack.translate(0.0, 0.92 - (double)piston, 0.0);
            }
            matrixStack.mulPose(new Quaternionf().rotateX(-1.5707964f));
            float scale = 0.625f;
            matrixStack.scale(scale, scale, 1.0f);
            ClientUtils.mc().getItemRenderer().renderStatic(displays.get(0), ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, level, 0);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }
}

