/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.CrusherLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CrusherRenderer
extends IEMultiblockRenderer<CrusherLogic.State> {
    public static String NAME_LEFT = "crusher_barrel_left";
    public static String NAME_RIGHT = "crusher_barrel_right";
    public static DynamicModel BARREL_LEFT;
    public static DynamicModel BARREL_RIGHT;

    @Override
    public void render(IMultiblockContext<CrusherLogic.State> ctx, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        CrusherLogic.State state = ctx.getState();
        MultiblockOrientation orientation = ctx.getLevel().getOrientation();
        Direction dir = orientation.front();
        boolean active = state.shouldRenderActive();
        float angle = state.getBarrelAngle() + (active ? 18.0f * partialTicks : 0.0f);
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.5, 0.5);
        matrixStack.translate((double)dir.getStepX() * 0.5, 0.0, (double)dir.getStepZ() * 0.5);
        matrixStack.pushPose();
        matrixStack.mulPose(new Quaternionf().rotateAxis(angle * ((float)Math.PI / 180), (Vector3fc)new Vector3f((float)(-dir.getStepZ()), 0.0f, (float)dir.getStepX())));
        this.renderBarrel(BARREL_LEFT, matrixStack, bufferIn, dir, combinedLightIn, combinedOverlayIn);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate((float)(dir.getStepX() * -1), 0.0f, (float)(dir.getStepZ() * -1));
        matrixStack.mulPose(new Quaternionf().rotateAxis(-angle * ((float)Math.PI / 180), (Vector3fc)new Vector3f((float)(-dir.getStepZ()), 0.0f, (float)dir.getStepX())));
        this.renderBarrel(BARREL_RIGHT, matrixStack, bufferIn, dir, combinedLightIn, combinedOverlayIn);
        matrixStack.popPose();
        matrixStack.popPose();
    }

    private void renderBarrel(DynamicModel barrel, PoseStack matrix, MultiBufferSource buffer, Direction facing, int light, int overlay) {
        matrix.pushPose();
        matrix.translate(-0.5, -0.5, -0.5);
        List quads = barrel.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        CrusherRenderer.rotateForFacing(matrix, facing);
        RenderUtils.renderModelTESRFast(quads, buffer.getBuffer(RenderType.solid()), matrix, light, overlay);
        matrix.popPose();
    }
}

