/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.utils.InvertingVertexBuffer;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;

public class BERenderUtils {
    public static <T extends IEBlockInterfaces.IMirrorAble & IEBlockInterfaces.IDirectionalBE> MultiBufferSource mirror(T tile, PoseStack mat, MultiBufferSource builderIn) {
        BERenderUtils.mirror(tile, mat);
        if (!tile.getIsMirrored()) {
            return builderIn;
        }
        return type -> new InvertingVertexBuffer(4, builderIn.getBuffer(type));
    }

    public static MultiBufferSource mirror(MultiblockOrientation orientation, PoseStack mat, MultiBufferSource builderIn) {
        if (orientation.mirrored()) {
            Direction facing = orientation.front();
            mat.scale(facing.getStepX() == 0 ? -1.0f : 1.0f, 1.0f, facing.getStepZ() == 0 ? -1.0f : 1.0f);
            return type -> new InvertingVertexBuffer(4, builderIn.getBuffer(type));
        }
        return builderIn;
    }

    public static <T extends IEBlockInterfaces.IMirrorAble & IEBlockInterfaces.IDirectionalBE> void mirror(T tile, PoseStack mat) {
        if (tile.getIsMirrored()) {
            Direction facing = ((IEBlockInterfaces.IDirectionalBE)tile).getFacing();
            mat.scale(facing.getStepX() == 0 ? -1.0f : 1.0f, 1.0f, facing.getStepZ() == 0 ? -1.0f : 1.0f);
        }
    }
}

