/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.entities.FluorescentTubeEntity;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class FluorescentTubeRenderer
extends EntityRenderer<FluorescentTubeEntity> {
    private TextureAtlasSprite tex;
    private static ItemStack tube = ItemStack.EMPTY;
    private static ItemStack tubeActive = ItemStack.EMPTY;

    public FluorescentTubeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
        this.shadowStrength = 0.0f;
        this.shadowRadius = 0.0f;
    }

    public ResourceLocation getTextureLocation(FluorescentTubeEntity entity) {
        return null;
    }

    public void render(FluorescentTubeEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0f, 1.0f, 0.0f);
        matrixStackIn.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.PI / 180 * (entityYaw + 90.0f), 0.0f));
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, 0.0, 0.03125);
        matrixStackIn.mulPose(new Quaternionf().rotateXYZ(entity.angleHorizontal * ((float)Math.PI / 180), 0.0f, 0.0f));
        matrixStackIn.translate(0.0f, -1.5f / 2.0f, 0.0f);
        FluorescentTubeRenderer.drawTube(entity.active, entity.rgb, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, entity.level());
        matrixStackIn.popPose();
        matrixStackIn.translate(-0.25, -1.0, 0.0);
        if (this.tex == null) {
            this.tex = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.withDefaultNamespace((String)"block/iron_block"));
        }
        VertexConsumer builder = bufferIn.getBuffer(RenderType.solid());
        RenderUtils.renderTexturedBox(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 0.0625f, this.tex.getU0(), this.tex.getV0(), this.tex.getU1(), this.tex.getV1(), packedLightIn);
        RenderUtils.renderTexturedBox(builder, matrixStackIn, 0.0625f, 0.9375f, 0.0f, 0.25f, 1.0f, 0.0625f, this.tex.getU0(), this.tex.getV0(), this.tex.getU1(), this.tex.getV1(), packedLightIn);
        matrixStackIn.popPose();
    }

    static void drawTube(boolean active, Color4 rgb, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay, Level level) {
        if (tube.isEmpty()) {
            tube = new ItemStack(IEItems.Misc.FLUORESCENT_TUBE);
        }
        if (tubeActive.isEmpty()) {
            tubeActive = new ItemStack(IEItems.Misc.FLUORESCENT_TUBE);
            FluorescentTubeItem.setLit(tubeActive, 0.6f);
        }
        matrixStack.translate(0.0, 0.75, 0.0);
        ItemStack renderStack = active ? tubeActive : tube;
        FluorescentTubeItem.setRGB(renderStack, rgb);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        itemRenderer.renderStatic(renderStack, ItemDisplayContext.NONE, light, overlay, matrixStack, buffer, level, 0);
    }
}

