/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.client.models.split.UnbakedSplitModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.client.model.ExtendedBlockModelDeserializer;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

public class SplitModelLoader
implements IGeometryLoader<UnbakedSplitModel> {
    public static final ResourceLocation LOCATION = IEApi.ieLoc("basic_split");
    public static final String PARTS = "split_parts";
    public static final String INNER_MODEL = "inner_model";
    public static final String DYNAMIC = "dynamic";

    @Nonnull
    public UnbakedSplitModel read(JsonObject modelContents, @Nonnull JsonDeserializationContext deserializationContext) {
        JsonElement innerJson = modelContents.get(INNER_MODEL);
        UnbakedModel baseModel = (UnbakedModel)ExtendedBlockModelDeserializer.INSTANCE.fromJson(innerJson, BlockModel.class);
        JsonArray partsJson = modelContents.getAsJsonArray(PARTS);
        ArrayList<Vec3i> parts = new ArrayList<Vec3i>(partsJson.size());
        for (Object e : partsJson) {
            parts.add(this.fromJson(e.getAsJsonArray()));
        }
        BoundingBox box = this.pointBB((Vec3i)parts.get(0));
        for (Vec3i v : parts) {
            box.encapsulate(this.pointBB(v));
        }
        Vec3i size = new Vec3i(box.getXSpan(), box.getYSpan(), box.getZSpan());
        return new UnbakedSplitModel(baseModel, parts, modelContents.get(DYNAMIC).getAsBoolean(), size);
    }

    private Vec3i fromJson(JsonArray a) {
        return new Vec3i(a.get(0).getAsInt(), a.get(1).getAsInt(), a.get(2).getAsInt());
    }

    private BoundingBox pointBB(Vec3i point) {
        return new BoundingBox(new BlockPos(point));
    }
}

