/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.item;

import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.item.DrillCallbacks;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.SawbladeItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BuzzsawCallbacks
implements ItemCallback<Key> {
    public static final BuzzsawCallbacks INSTANCE = new BuzzsawCallbacks();
    private static final List<List<String>> GROUP_BLADE = List.of(List.of("blade"));
    private static final Transformation MAT_FIXED = new Transformation(new Vector3f(0.60945f, 0.0f, 0.0f), null, null, null);

    @Override
    public Key extractKey(ItemStack stack, LivingEntity owner) {
        UpgradeData upgrades = BuzzsawItem.getUpgradesStatic(stack);
        boolean hasQuiver = BuzzsawItem.hasQuiverUpgrade(stack);
        int numBlades = hasQuiver ? 3 : 1;
        ArrayList<ResourceLocation> bladeTextures = new ArrayList<ResourceLocation>();
        for (int i = 0; i < numBlades; ++i) {
            ItemStack sawblade = BuzzsawItem.getSawblade(stack, i);
            Item item = sawblade.getItem();
            if (item instanceof SawbladeItem) {
                SawbladeItem sawbladeItem = (SawbladeItem)item;
                bladeTextures.add(sawbladeItem.getSawbladeTexture());
                continue;
            }
            bladeTextures.add(null);
        }
        return new Key(bladeTextures, hasQuiver, upgrades.has(UpgradeEffect.OILED));
    }

    @Override
    public TextureAtlasSprite getTextureReplacement(Key key, String group, String material) {
        int spare;
        ResourceLocation rl;
        if ("blade".equals(material) && (rl = key.bladeTexture.get(spare = "upgrade_blades1".equals(group) ? 1 : ("upgrade_blades2".equals(group) ? 2 : 0))) != null) {
            return ClientUtils.getSprite(rl);
        }
        return null;
    }

    @Override
    public boolean shouldRenderGroup(Key key, String group, RenderType layer) {
        if ("body".equals(group)) {
            return true;
        }
        if ("blade".equals(group)) {
            return key.bladeTexture.get(0) != null;
        }
        if ("upgrade_lube".equals(group)) {
            return key.oiled();
        }
        if ("upgrade_launcher".equals(group) || "upgrade_waterproof".equals(group)) {
            return false;
        }
        if ("upgrade_blades0".equals(group)) {
            return key.hasQuiver();
        }
        if ("upgrade_blades1".equals(group)) {
            return key.hasQuiver() && key.bladeTexture().get(1) != null;
        }
        if ("upgrade_blades2".equals(group)) {
            return key.hasQuiver() && key.bladeTexture().get(2) != null;
        }
        return true;
    }

    @Override
    public List<List<String>> getSpecialGroups(ItemStack stack, ItemDisplayContext transform, LivingEntity entity) {
        return GROUP_BLADE;
    }

    @Override
    @Nonnull
    public Transformation getTransformForGroups(ItemStack stack, List<String> groups, ItemDisplayContext transform, LivingEntity entity, float partialTicks) {
        if (!DrillCallbacks.shouldRotate(IEItems.Tools.BUZZSAW, entity, stack, transform)) {
            return MAT_FIXED;
        }
        float ticksPerRotation = 10.0f;
        float angle = ((float)entity.tickCount % ticksPerRotation + partialTicks) / ticksPerRotation * ((float)Math.PI * 2);
        return new Transformation(new Vector3f(0.60945f, 0.0f, 0.0f), new Quaternionf().rotateXYZ(0.0f, angle, 0.0f), null, null);
    }

    @Override
    public Key getDefaultKey() {
        return new Key(Arrays.asList(null, null, null), false, false);
    }

    public record Key(List<ResourceLocation> bladeTexture, boolean hasQuiver, boolean oiled) {
    }
}

