/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class SparksParticle
extends TextureSheetParticle {
    public SparksParticle(ClientLevel world, double x, double y, double z, double mx, double my, double mz, SpriteSet sprite) {
        super(world, x, y, z, mx, my, mz);
        this.setLifetime(16);
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = mx;
        this.yd = my;
        this.zd = mz;
        this.pickSprite(sprite);
    }

    public int getLightColor(float p_70070_1_) {
        return 0xF000F0;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        int particleAge = this.age;
        this.setColor(1.0f, 0.2f + (float)(16 - particleAge) / 16.0f, particleAge > 4 ? 0.0f : (float)(4 - particleAge) / 4.0f);
        super.render(buffer, renderInfo, partialTicks);
    }

    @Nonnull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SparksParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
        }
    }
}

