/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.localhandlers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.ICollisionHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.utils.IElectricDamageSource;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WireDamageHandler
extends LocalNetworkHandler
implements ICollisionHandler {
    public static final ResourceLocation ID = IEApi.ieLoc("wire_damage");
    public static final SetRestrictedField<WireDamageGetter> GET_WIRE_DAMAGE = SetRestrictedField.common();
    private static final double KNOCKBACK_PER_DAMAGE = 10.0;

    public WireDamageHandler(LocalWireNetwork net, GlobalWireNetwork global) {
        super(net, global);
    }

    @Override
    public void onCollided(LivingEntity e, BlockPos pos, WireCollisionData.CollisionInfo info) {
        boolean collides;
        WireType wType = info.connection().type;
        if (!(wType instanceof IShockingWire)) {
            return;
        }
        IShockingWire shockWire = (IShockingWire)((Object)wType);
        EnergyTransferHandler energyHandler = this.getEnergyHandler();
        if (energyHandler == null) {
            return;
        }
        double extra = shockWire.getDamageRadius();
        AABB eAabb = e.getBoundingBox();
        AABB includingExtra = eAabb.inflate(extra).move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
        boolean bl = collides = includingExtra.contains(info.intersectA()) || includingExtra.contains(info.intersectB());
        if (!collides && includingExtra.clip(info.intersectA(), info.intersectB()).isEmpty()) {
            return;
        }
        ConnectionPoint target = info.connection().getEndA();
        List<SourceData> available = this.getAvailableEnergy(energyHandler, target);
        if (available.isEmpty()) {
            return;
        }
        int totalAvailable = 0;
        for (SourceData source : available) {
            totalAvailable = (int)((double)totalAvailable + (double)source.amountAvailable * (1.0 - source.pathToSource.loss));
        }
        totalAvailable = Math.min(totalAvailable, shockWire.getTransferRate());
        float maxPossibleDamage = shockWire.getDamageAmount((Entity)e, info.connection(), totalAvailable);
        if (maxPossibleDamage <= 0.0f) {
            return;
        }
        IElectricDamageSource dmg = GET_WIRE_DAMAGE.get().make(e.level(), maxPossibleDamage, shockWire.getElectricSource());
        if (!dmg.apply((Entity)e)) {
            return;
        }
        float actualDamage = dmg.getDamage();
        Vec3 v = e.getLookAngle();
        ApiUtils.knockbackNoSource(e, (double)actualDamage / 10.0, v.x, v.z);
        double factor = actualDamage / maxPossibleDamage;
        Object2DoubleMap<Connection> transferred = energyHandler.getTransferredNextTick();
        for (SourceData source : available) {
            double energyFromSource = (double)source.amountAvailable * factor;
            source.source.extractEnergy(Mth.ceil((double)energyFromSource));
            for (Connection c : source.pathToSource.conns) {
                transferred.mergeDouble((Object)c, energyFromSource, Double::sum);
            }
        }
    }

    private List<SourceData> getAvailableEnergy(EnergyTransferHandler energyHandler, ConnectionPoint target) {
        ArrayList<SourceData> ret = new ArrayList<SourceData>();
        Map<ConnectionPoint, EnergyTransferHandler.Path> paths = null;
        for (Map.Entry<ConnectionPoint, EnergyTransferHandler.EnergyConnector> c : energyHandler.getSources().entrySet()) {
            EnergyTransferHandler.Path path;
            int energy = c.getValue().getAvailableEnergy();
            if (energy <= 0) continue;
            if (paths == null) {
                paths = energyHandler.getPathsFromSource(target);
            }
            if ((path = paths.get(c.getKey())) == null) continue;
            ret.add(new SourceData(energy, path, c.getValue()));
        }
        return ret;
    }

    private EnergyTransferHandler getEnergyHandler() {
        return this.localNet.getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class);
    }

    @Override
    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        return this;
    }

    @Override
    public void onConnectorLoaded(ConnectionPoint p, IImmersiveConnectable iic) {
    }

    @Override
    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
    }

    @Override
    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
    }

    @Override
    public void onConnectionAdded(Connection c) {
    }

    @Override
    public void onConnectionRemoved(Connection c) {
    }

    public static interface IShockingWire
    extends EnergyTransferHandler.IEnergyWire {
        public double getDamageRadius();

        public IElectricEquipment.ElectricSource getElectricSource();

        default public float getDamageAmount(Entity e, Connection c, int energy) {
            return 0.0f;
        }
    }

    private record SourceData(int amountAvailable, EnergyTransferHandler.Path pathToSource, EnergyTransferHandler.EnergyConnector source) {
    }

    public static interface WireDamageGetter {
        public IElectricDamageSource make(Level var1, float var2, IElectricEquipment.ElectricSource var3);
    }
}

