/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.world.entity.Entity;

public class EntityCollisionTracker {
    private final int ticksInMemory;
    private final TrackedTick[] collidingByTick;
    private final IntSet collidedInRange = new IntOpenHashSet();
    private int nextIndex = 0;
    private TrackedTick collidingInCurrentTick = new TrackedTick();

    public EntityCollisionTracker(int ticksInMemory) {
        this.ticksInMemory = ticksInMemory;
        this.collidingByTick = new TrackedTick[ticksInMemory];
        for (int i = 0; i < ticksInMemory; ++i) {
            this.collidingByTick[i] = new TrackedTick();
        }
    }

    private void updateForTick(long currentTick) {
        boolean updateRange = false;
        if (currentTick != this.collidingInCurrentTick.tick) {
            this.collidingByTick[this.nextIndex] = this.collidingInCurrentTick;
            this.nextIndex = (this.nextIndex + 1) % this.ticksInMemory;
            this.collidingInCurrentTick = new TrackedTick(currentTick);
            updateRange = true;
        }
        for (int i = 0; i < this.ticksInMemory; ++i) {
            if (this.collidingByTick[i].isRelevant(currentTick)) continue;
            updateRange = true;
            this.collidingByTick[i] = new TrackedTick();
        }
        if (updateRange) {
            this.collidedInRange.clear();
            for (TrackedTick tick : this.collidingByTick) {
                this.collidedInRange.addAll((IntCollection)tick.entities);
            }
        }
    }

    public void onEntityCollided(Entity collided) {
        this.updateForTick(collided.level().getGameTime());
        this.collidingInCurrentTick.entities.add(collided.getId());
    }

    public int getCollidedInRange(long currentTick) {
        this.updateForTick(currentTick);
        return this.collidedInRange.size();
    }

    private class TrackedTick {
        private static final long INVALID_TICK = -1L;
        private final IntSet entities;
        private final long tick;

        private TrackedTick() {
            this(-1L);
        }

        private TrackedTick(long tick) {
            this.tick = tick;
            this.entities = new IntOpenHashSet();
        }

        public boolean isRelevant(long currentTick) {
            return this.tick == -1L || currentTick - this.tick <= (long)(EntityCollisionTracker.this.ticksInMemory + 3);
        }
    }
}

