/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.fml.ModList;

public class IEApi {
    public static List<? extends String> modPreference;
    private static final Map<TagKey<Item>, ItemStack> oreOutputPreference;
    public static Map<String, Integer[]> prefixToIngotMap;
    public static List<Runnable> renderCacheClearers;

    public static ItemStack getPreferredTagStack(RegistryAccess tags, TagKey<Item> tag) {
        return oreOutputPreference.computeIfAbsent(tag, rl -> IEApi.getPreferredElementbyMod(TagUtils.elementStream(tags, rl), tags.registryOrThrow(Registries.ITEM)).orElse(Items.AIR).getDefaultInstance()).copy();
    }

    public static <T> Optional<T> getPreferredElementbyMod(Stream<T> list, Registry<T> registry) {
        return IEApi.getPreferredElementbyMod(list, arg_0 -> registry.getKey(arg_0));
    }

    public static <T> Optional<T> getPreferredElementbyMod(Stream<T> list, Function<T, ResourceLocation> getName) {
        return list.min(Comparator.comparingInt(t -> {
            ResourceLocation name = (ResourceLocation)getName.apply(t);
            String modId = name.getNamespace();
            int idx = modPreference.indexOf(modId);
            if (idx < 0) {
                return modPreference.size();
            }
            return idx;
        }).thenComparing(getName));
    }

    public static ItemStack getPreferredStackbyMod(ItemStack[] array) {
        return IEApi.getPreferredElementbyMod(Arrays.stream(array), (T stack) -> BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).orElseThrow(() -> new RuntimeException("Empty array?"));
    }

    public static boolean isAllowedInCrate(ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems() && !stack.is(IETags.forbiddenInCrates);
    }

    public static String getCurrentVersion() {
        return ModList.get().getModFileById("immersiveengineering").versionString();
    }

    public static ResourceLocation ieLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"immersiveengineering", (String)path);
    }

    static {
        oreOutputPreference = new HashMap<TagKey<Item>, ItemStack>();
        prefixToIngotMap = new HashMap<String, Integer[]>();
        renderCacheClearers = new ArrayList<Runnable>();
    }
}

