/*
 * Decompiled with CFR 0.152.
 */
package dev.dawson.ultiminecobblemon;

import dev.ftb.mods.ftbultimine.api.rightclick.RightClickHandler;
import dev.ftb.mods.ftbultimine.api.shape.ShapeContext;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public final class CobblemonRightClickHandler
implements RightClickHandler {
    public int handleRightClickBlock(ShapeContext ctx, InteractionHand hand, Collection<BlockPos> positions) {
        ServerPlayer player = ctx.player();
        Level level = player.level();
        int handled = 0;
        for (BlockPos pos : positions) {
            BlockHitResult hit;
            InteractionResult result;
            BlockState state = level.getBlockState(pos);
            if (!this.isCobblemonBerryOrApricorn(state) || !(result = state.useWithoutItem(level, (Player)player, hit = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, false))).consumesAction()) continue;
            ++handled;
        }
        return handled;
    }

    private boolean isCobblemonBerryOrApricorn(BlockState state) {
        Optional optKey = state.getBlockHolder().unwrapKey();
        if (optKey.isEmpty()) {
            return false;
        }
        ResourceLocation id = ((ResourceKey)optKey.get()).location();
        if (!"cobblemon".equals(id.getNamespace())) {
            return false;
        }
        String p = id.getPath();
        return p.endsWith("_berry") || p.contains("apricorn");
    }
}

