/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.zombie_dungeon;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsapi.world.structure.processor.ISafeWorldModifier;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ZombieMainStairsProcessor
extends StructureProcessor
implements ISafeWorldModifier {
    public static final ZombieMainStairsProcessor INSTANCE = new ZombieMainStairsProcessor();
    public static final MapCodec<ZombieMainStairsProcessor> CODEC = MapCodec.unit(() -> INSTANCE);
    private static final BlockStateRandomizer STAIR_SELECTOR = new BlockStateRandomizer(Blocks.COBBLESTONE_STAIRS.defaultBlockState()).addBlock(Blocks.MOSSY_COBBLESTONE_STAIRS.defaultBlockState(), 0.4f).addBlock(Blocks.COBBLESTONE_SLAB.defaultBlockState(), 0.1f).addBlock(Blocks.MOSSY_COBBLESTONE_SLAB.defaultBlockState(), 0.1f).addBlock(Blocks.CAVE_AIR.defaultBlockState(), 0.1f).addBlock(Blocks.COBBLESTONE.defaultBlockState(), 0.1f).addBlock(Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 0.1f);
    private static final BlockStateRandomizer COBBLE_SELECTOR = new BlockStateRandomizer(Blocks.COBBLESTONE.defaultBlockState()).addBlock(Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 0.3f);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().getBlock() == Blocks.WARPED_STAIRS) {
            BlockState lanternBlock;
            int middleSurfaceHeight;
            BlockPos.MutableBlockPos temp = blockInfoGlobal.pos().mutable();
            Direction facing = structurePlacementData.getRotation().rotate((Direction)blockInfoGlobal.state().getValue((Property)StairBlock.FACING));
            Rotation rotation = structurePlacementData.getRotation().getRotated(Rotation.CLOCKWISE_180);
            int maxLength = BetterDungeonsCommon.CONFIG.zombieDungeons.zombieDungeonMaxSurfaceStaircaseLength;
            BlockPos maxSurfacePos = blockInfoGlobal.pos().relative(facing, maxLength).relative(Direction.UP, maxLength);
            temp.move(facing, maxLength);
            int surfaceHeight = levelReader.getHeight(Heightmap.Types.WORLD_SURFACE_WG, temp.getX(), temp.getZ());
            if (surfaceHeight >= maxSurfacePos.getY() || surfaceHeight <= blockInfoGlobal.pos().getY()) {
                blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.CAVE_AIR.defaultBlockState(), null);
                return blockInfoGlobal;
            }
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            BlockPos.MutableBlockPos leftPos = new BlockPos((Vec3i)blockInfoGlobal.pos().relative(facing.getCounterClockWise())).mutable();
            BlockPos.MutableBlockPos middlePos = new BlockPos((Vec3i)blockInfoGlobal.pos()).mutable();
            BlockPos.MutableBlockPos rightPos = new BlockPos((Vec3i)blockInfoGlobal.pos().relative(facing.getClockWise())).mutable();
            for (int i = 0; i < maxLength && (middleSurfaceHeight = levelReader.getHeight(Heightmap.Types.WORLD_SURFACE_WG, middlePos.getX(), middlePos.getZ())) >= middlePos.getY(); ++i) {
                int y;
                BlockState tempBlock = STAIR_SELECTOR.get(random);
                if (!this.isBlockStateAirSafe(levelReader, (BlockPos)leftPos)) {
                    if (this.isMaterialLiquidSafe(levelReader, leftPos.relative(facing))) {
                        this.setBlockStateSafeWithPlacement(levelReader, Blocks.COBBLESTONE.defaultBlockState(), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation);
                    } else {
                        this.setBlockStateSafeWithPlacement(levelReader, tempBlock, (BlockPos)leftPos, structurePlacementData.getMirror(), rotation);
                    }
                }
                tempBlock = STAIR_SELECTOR.get(random);
                if (!this.isBlockStateAirSafe(levelReader, (BlockPos)middlePos)) {
                    if (this.isMaterialLiquidSafe(levelReader, middlePos.relative(facing))) {
                        this.setBlockStateSafeWithPlacement(levelReader, Blocks.COBBLESTONE.defaultBlockState(), (BlockPos)middlePos, structurePlacementData.getMirror(), rotation);
                    } else {
                        this.setBlockStateSafeWithPlacement(levelReader, tempBlock, (BlockPos)middlePos, structurePlacementData.getMirror(), rotation);
                    }
                }
                tempBlock = STAIR_SELECTOR.get(random);
                if (!this.isBlockStateAirSafe(levelReader, (BlockPos)rightPos)) {
                    if (this.isMaterialLiquidSafe(levelReader, rightPos.relative(facing))) {
                        this.setBlockStateSafeWithPlacement(levelReader, Blocks.COBBLESTONE.defaultBlockState(), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
                    } else {
                        this.setBlockStateSafeWithPlacement(levelReader, tempBlock, (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
                    }
                }
                for (int y2 = middlePos.getY() + 1; y2 <= middlePos.getY() + 3; ++y2) {
                    temp.set(leftPos.getX(), y2, leftPos.getZ());
                    this.setBlockStateSafeWithPlacement(levelReader, Blocks.CAVE_AIR.defaultBlockState(), (BlockPos)temp, structurePlacementData.getMirror(), rotation);
                    temp.set(middlePos.getX(), y2, middlePos.getZ());
                    this.setBlockStateSafeWithPlacement(levelReader, Blocks.CAVE_AIR.defaultBlockState(), (BlockPos)temp, structurePlacementData.getMirror(), rotation);
                    temp.set(rightPos.getX(), y2, rightPos.getZ());
                    this.setBlockStateSafeWithPlacement(levelReader, Blocks.CAVE_AIR.defaultBlockState(), (BlockPos)temp, structurePlacementData.getMirror(), rotation);
                }
                float cobbleChance = (float)(maxLength - i) / (float)maxLength;
                cobbleChance = Math.max(cobbleChance, 0.25f);
                temp.set(leftPos.getX(), leftPos.getY() + 4, leftPos.getZ());
                Optional tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).liquid() || random.nextFloat() < cobbleChance && ((BlockState)tempOptional.get()).isSolid()) {
                    this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.getMirror(), rotation);
                }
                temp.set(middlePos.getX(), middlePos.getY() + 4, middlePos.getZ());
                tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).liquid() || random.nextFloat() < cobbleChance && ((BlockState)tempOptional.get()).isSolid()) {
                    this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.getMirror(), rotation);
                }
                temp.set(rightPos.getX(), rightPos.getY() + 4, rightPos.getZ());
                tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).liquid() || random.nextFloat() < cobbleChance && ((BlockState)tempOptional.get()).isSolid()) {
                    this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.getMirror(), rotation);
                }
                temp.set((Vec3i)leftPos.relative(facing.getCounterClockWise()));
                for (y = 0; y <= 4; ++y) {
                    tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                    if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).liquid() || random.nextFloat() < cobbleChance && ((BlockState)tempOptional.get()).isSolid()) {
                        this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.getMirror(), rotation);
                    }
                    temp.move(Direction.UP);
                }
                temp.set((Vec3i)rightPos.relative(facing.getClockWise()));
                for (y = 0; y <= 4; ++y) {
                    tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                    if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).liquid() || random.nextFloat() < cobbleChance && ((BlockState)tempOptional.get()).isSolid()) {
                        this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.getMirror(), rotation);
                    }
                    temp.move(Direction.UP);
                }
                leftPos.move(facing).move(Direction.UP);
                middlePos.move(facing).move(Direction.UP);
                rightPos.move(facing).move(Direction.UP);
            }
            leftPos.move(facing.getOpposite()).move(Direction.DOWN);
            middlePos.move(facing.getOpposite()).move(Direction.DOWN);
            rightPos.move(facing.getOpposite()).move(Direction.DOWN);
            BlockStateRandomizer tombSelector = new BlockStateRandomizer(Blocks.COBBLESTONE.defaultBlockState()).addBlock(Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 0.4f);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), leftPos.relative(Direction.UP, 2), structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), middlePos.relative(Direction.UP, 2), structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), rightPos.relative(Direction.UP, 2), structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.SMOOTH_STONE.defaultBlockState(), leftPos.relative(Direction.UP, 3), structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.SMOOTH_STONE.defaultBlockState(), middlePos.relative(Direction.UP, 3), structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.SMOOTH_STONE.defaultBlockState(), rightPos.relative(Direction.UP, 3), structurePlacementData.getMirror(), rotation);
            BlockState blockState = lanternBlock = BetterDungeonsCommon.CONFIG.general.enableNetherBlocks ? (BlockState)Blocks.SOUL_LANTERN.defaultBlockState().setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true)) : (BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true));
            if (random.nextFloat() < 0.25f) {
                this.setBlockStateSafeWithPlacement(levelReader, lanternBlock, leftPos.relative(Direction.UP, 1), structurePlacementData.getMirror(), rotation);
            } else if (random.nextFloat() < 0.25f) {
                this.setBlockStateSafeWithPlacement(levelReader, lanternBlock, rightPos.relative(Direction.UP, 1), structurePlacementData.getMirror(), rotation);
            }
            leftPos.move(facing.getCounterClockWise());
            rightPos.move(facing.getClockWise());
            this.setColumn(levelReader, tombSelector, leftPos.relative(Direction.DOWN), random);
            this.setColumn(levelReader, tombSelector, rightPos.relative(Direction.DOWN), random);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.POLISHED_ANDESITE.defaultBlockState(), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.POLISHED_ANDESITE.defaultBlockState(), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
            leftPos.move(Direction.UP);
            rightPos.move(Direction.UP);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.POLISHED_ANDESITE.defaultBlockState(), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.POLISHED_ANDESITE.defaultBlockState(), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
            leftPos.move(Direction.UP);
            rightPos.move(Direction.UP);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.SMOOTH_STONE.defaultBlockState(), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.SMOOTH_STONE.defaultBlockState(), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
            leftPos.move(Direction.UP);
            rightPos.move(Direction.UP);
            this.setBlockStateRandom(levelReader, Blocks.SMOOTH_STONE.defaultBlockState(), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation, random, 0.5f);
            this.setBlockStateRandom(levelReader, Blocks.SMOOTH_STONE.defaultBlockState(), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation, random, 0.5f);
            leftPos.move(Direction.DOWN).move(Direction.DOWN).move(Direction.DOWN).move(facing.getOpposite());
            rightPos.move(Direction.DOWN).move(Direction.DOWN).move(Direction.DOWN).move(facing.getOpposite());
            this.setColumn(levelReader, tombSelector, leftPos.relative(Direction.DOWN), random);
            this.setColumn(levelReader, tombSelector, rightPos.relative(Direction.DOWN), random);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
            leftPos.move(Direction.UP);
            rightPos.move(Direction.UP);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
            leftPos.move(Direction.UP);
            rightPos.move(Direction.UP);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation, random, 0.5f);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation, random, 0.5f);
            leftPos.move(Direction.DOWN).move(Direction.DOWN).move(facing.getOpposite());
            rightPos.move(Direction.DOWN).move(Direction.DOWN).move(facing.getOpposite());
            this.setColumn(levelReader, tombSelector, leftPos.relative(Direction.DOWN), random);
            this.setColumn(levelReader, tombSelector, rightPos.relative(Direction.DOWN), random);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
            leftPos.move(Direction.UP);
            rightPos.move(Direction.UP);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation, random, 0.5f);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
            leftPos.move(Direction.UP);
            rightPos.move(Direction.UP);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation, random, 0.5f);
            leftPos.move(Direction.DOWN).move(Direction.DOWN).move(facing.getOpposite());
            rightPos.move(Direction.DOWN).move(Direction.DOWN).move(facing.getOpposite());
            this.setColumn(levelReader, tombSelector, leftPos.relative(Direction.DOWN), random);
            this.setColumn(levelReader, tombSelector, rightPos.relative(Direction.DOWN), random);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.getMirror(), rotation, random, 0.5f);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation);
            leftPos.move(Direction.UP);
            rightPos.move(Direction.UP);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.getMirror(), rotation, random, 0.5f);
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), STAIR_SELECTOR.get(random), blockInfoGlobal.nbt());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.ZOMBIE_MAIN_STAIRS_PROCESSOR;
    }

    private void setBlockStateSafeWithPlacement(LevelReader levelReader, BlockState blockState, BlockPos pos, Mirror mirror, Rotation rotation) {
        if (mirror != Mirror.NONE) {
            blockState = blockState.mirror(mirror);
        }
        if (rotation != Rotation.NONE) {
            blockState = blockState.rotate(rotation);
        }
        this.setBlockStateSafe(levelReader, pos, blockState);
    }

    private void setBlockStateRandom(LevelReader levelReader, BlockState blockState, BlockPos pos, Mirror mirror, Rotation rotation, RandomSource random, float chance) {
        if (random.nextFloat() < chance) {
            this.setBlockStateSafeWithPlacement(levelReader, blockState, pos, mirror, rotation);
        }
    }

    private void setColumn(LevelReader levelReader, BlockStateRandomizer selector, BlockPos pos, RandomSource random) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        Optional currBlock = this.getBlockStateSafe(levelReader, (BlockPos)mutable);
        while (mutable.getY() > levelReader.getMinBuildHeight() && (currBlock.isEmpty() || ((BlockState)currBlock.get()).isAir() || ((BlockState)currBlock.get()).liquid())) {
            this.setBlockStateSafe(levelReader, (BlockPos)mutable, selector.get(random));
            mutable.move(Direction.DOWN);
            currBlock = this.getBlockStateSafe(levelReader, (BlockPos)mutable);
        }
    }
}

