/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.codec.KubeJSCodecs;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.util.OpsContainer;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.type.EnumTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.RemappedEnumConstant;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public final class EnumComponent<T extends Enum<T>>
extends Record
implements RecipeComponent<T> {
    @Nullable
    private final RecipeComponentType<?> typeOverride;
    private final EnumTypeInfo typeInfo;
    private final Codec<T> codec;
    public static final RecipeComponentType<?> TYPE = RecipeComponentType.dynamic(KubeJS.id("enum"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)KubeJSCodecs.ENUM_TYPE_INFO.fieldOf("enum").validate(type -> {
        if (StringRepresentable.class.isAssignableFrom(type.asClass())) {
            return DataResult.success((Object)type);
        }
        return DataResult.error(() -> "Enum class " + String.valueOf(type) + " is not StringRepresentable!");
    }).forGetter(EnumComponent::typeInfo)).apply((Applicative)instance, EnumComponent::new)));

    private EnumComponent(EnumTypeInfo typeInfo) {
        this(null, typeInfo, Codec.STRING.flatXmap(s -> {
            for (Object c : typeInfo.enumConstants()) {
                Enum e;
                RemappedEnumConstant r;
                if (c instanceof RemappedEnumConstant && (r = (RemappedEnumConstant)c).getRemappedEnumConstantName().equalsIgnoreCase((String)s)) {
                    return DataResult.success(c);
                }
                if (!(c instanceof Enum) || !(e = (Enum)c).name().equalsIgnoreCase((String)s)) continue;
                return DataResult.success(c);
            }
            return DataResult.error(() -> "Enum value '" + s + "' of " + typeInfo.asClass().getName() + " not found");
        }, o -> DataResult.success((Object)EnumTypeInfo.getName((Object)o))));
    }

    public EnumComponent(@Nullable RecipeComponentType<?> typeOverride, EnumTypeInfo typeInfo, Codec<T> codec) {
        this.typeOverride = typeOverride;
        this.typeInfo = typeInfo;
        this.codec = codec;
    }

    public static <T extends Enum<T>> RecipeComponentType<T> of(ResourceLocation id, Class<T> enumClass, Codec<T> codec) {
        return RecipeComponentType.unit(id, type -> new EnumComponent((RecipeComponentType<?>)type, (EnumTypeInfo)TypeInfo.of((Class)enumClass), codec));
    }

    public static <T extends Enum<T>> RecipeComponentType<T> of(ResourceLocation id, Class<T> enumClass) {
        return EnumComponent.of(id, enumClass, StringRepresentable.fromEnum(enumClass::getEnumConstants));
    }

    @Override
    public RecipeComponentType<?> type() {
        return this.typeOverride == null ? TYPE : this.typeOverride;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, T value) {
        if (value instanceof RemappedEnumConstant) {
            RemappedEnumConstant r = (RemappedEnumConstant)value;
            builder.append(r.getRemappedEnumConstantName());
        } else if (value instanceof Enum) {
            T e = value;
            builder.append(((Enum)e).name());
        } else {
            builder.append(((Enum)value).toString());
        }
    }

    @Override
    public String toString() {
        if (this.typeOverride != null) {
            return this.typeOverride.toString();
        }
        return "enum<" + this.typeInfo.asClass().getName() + ">";
    }

    @Override
    public String toString(OpsContainer ops, T value) {
        return ScriptRuntime.escapeAndWrapString((String)((StringRepresentable)value).getSerializedName());
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnumComponent.class, "typeOverride;typeInfo;codec", "typeOverride", "typeInfo", "codec"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnumComponent.class, "typeOverride;typeInfo;codec", "typeOverride", "typeInfo", "codec"}, this, o);
    }

    @Nullable
    public RecipeComponentType<?> typeOverride() {
        return this.typeOverride;
    }

    public EnumTypeInfo typeInfo() {
        return this.typeInfo;
    }

    @Override
    public Codec<T> codec() {
        return this.codec;
    }
}

