/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.latvian.mods.kubejs.client.KubeSessionData;
import dev.latvian.mods.kubejs.integration.emi.EMIAddEntriesKubeEvent;
import dev.latvian.mods.kubejs.integration.emi.EMIAddInformationKubeEvent;
import dev.latvian.mods.kubejs.integration.emi.EMIIntegration;
import dev.latvian.mods.kubejs.integration.emi.EMIRemoveEntriesKubeEvent;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.plugin.builtin.event.RecipeViewerEvents;
import dev.latvian.mods.kubejs.recipe.viewer.RecipeViewerEntryType;
import dev.latvian.mods.kubejs.recipe.viewer.server.CategoryData;
import dev.latvian.mods.kubejs.recipe.viewer.server.FluidData;
import dev.latvian.mods.kubejs.recipe.viewer.server.ItemData;
import dev.latvian.mods.kubejs.recipe.viewer.server.RecipeViewerData;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

@EmiEntrypoint
public class KubeJSEMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        RecipeViewerData remote;
        KubeSessionData sessionData = KubeSessionData.of(Minecraft.getInstance());
        RecipeViewerData recipeViewerData = remote = sessionData == null ? null : sessionData.recipeViewerData;
        if (remote != null) {
            Set<ResourceLocation> removedCategories = Set.copyOf(remote.removedCategories());
            Set<ResourceLocation> set = Set.copyOf(remote.removedGlobalRecipes());
            HashMap<ResourceLocation, Set<ResourceLocation>> removedRecipes = new HashMap<ResourceLocation, Set<ResourceLocation>>();
            for (CategoryData data : remote.categoryData()) {
                removedRecipes.put(data.category(), Set.copyOf(data.removedRecipes()));
            }
            registry.removeRecipes(r -> {
                ResourceLocation cat = r.getCategory().getId();
                if (cat == null) {
                    return false;
                }
                if (removedCategories.contains(cat)) {
                    return true;
                }
                ResourceLocation id = r.getId();
                if (id == null) {
                    return false;
                }
                return globalRemovedRecipes.contains(id) || removedRecipes.getOrDefault(cat, Set.of()).contains(id);
            });
        }
        for (RecipeViewerEntryType recipeViewerEntryType : RecipeViewerEntryType.ALL_TYPES.get()) {
            if (RecipeViewerEvents.REMOVE_ENTRIES.hasListeners(recipeViewerEntryType)) {
                RecipeViewerEvents.REMOVE_ENTRIES.post(ScriptType.CLIENT, recipeViewerEntryType, new EMIRemoveEntriesKubeEvent(recipeViewerEntryType, registry));
            }
            if (!RecipeViewerEvents.REMOVE_ENTRIES_COMPLETELY.hasListeners(recipeViewerEntryType)) continue;
            RecipeViewerEvents.REMOVE_ENTRIES_COMPLETELY.post(ScriptType.CLIENT, recipeViewerEntryType, new EMIRemoveEntriesKubeEvent(recipeViewerEntryType, registry));
        }
        if (remote != null) {
            for (Ingredient ingredient : remote.itemData().removedEntries()) {
                registry.removeEmiStacks(EMIIntegration.predicate((ItemPredicate)ingredient));
            }
            for (Ingredient ingredient : remote.itemData().completelyRemovedEntries()) {
                registry.removeEmiStacks(EMIIntegration.predicate((ItemPredicate)ingredient));
            }
            for (FluidIngredient fluidIngredient : remote.fluidData().removedEntries()) {
                registry.removeEmiStacks(EMIIntegration.predicate(fluidIngredient));
            }
            for (FluidIngredient fluidIngredient : remote.fluidData().completelyRemovedEntries()) {
                registry.removeEmiStacks(EMIIntegration.predicate(fluidIngredient));
            }
        }
        for (RecipeViewerEntryType recipeViewerEntryType : RecipeViewerEntryType.ALL_TYPES.get()) {
            if (!RecipeViewerEvents.ADD_ENTRIES.hasListeners(recipeViewerEntryType)) continue;
            RecipeViewerEvents.ADD_ENTRIES.post(ScriptType.CLIENT, recipeViewerEntryType, new EMIAddEntriesKubeEvent(recipeViewerEntryType, registry));
        }
        if (remote != null) {
            for (ItemStack itemStack : remote.itemData().addedEntries()) {
                registry.addEmiStack(EmiStack.of((ItemStack)itemStack));
            }
            for (FluidStack fluidStack : remote.fluidData().addedEntries()) {
                registry.addEmiStack(EmiStack.of((Fluid)fluidStack.getFluid(), (DataComponentPatch)fluidStack.getComponentsPatch(), (long)fluidStack.getAmount()));
            }
        }
        for (RecipeViewerEntryType recipeViewerEntryType : RecipeViewerEntryType.ALL_TYPES.get()) {
            if (!RecipeViewerEvents.ADD_INFORMATION.hasListeners(recipeViewerEntryType)) continue;
            RecipeViewerEvents.ADD_INFORMATION.post(ScriptType.CLIENT, recipeViewerEntryType, new EMIAddInformationKubeEvent(recipeViewerEntryType, registry));
        }
        if (remote != null) {
            for (ItemData.Info info : remote.itemData().info()) {
                registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiIngredient.of((Ingredient)info.filter())), info.info(), null));
            }
            for (FluidData.Info info : remote.fluidData().info()) {
                registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EMIIntegration.fluidIngredient(info.filter())), info.info(), null));
            }
        }
    }
}

