/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.color.SimpleColor;
import dev.latvian.mods.kubejs.color.SimpleColorWithAlpha;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ColorWrapper;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.type.TypeInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface BlockTintFunction {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(BlockTintFunction.class);
    public static final BlockTintFunction GRASS = (s, l, p, i) -> new SimpleColor(l == null || p == null ? GrassColor.get((double)0.5, (double)1.0) : BiomeColors.getAverageGrassColor((BlockAndTintGetter)l, (BlockPos)p));
    public static final KubeColor DEFAULT_FOLIAGE_COLOR = new SimpleColor(FoliageColor.getDefaultColor());
    public static final BlockTintFunction FOLIAGE = (s, l, p, i) -> l == null || p == null ? DEFAULT_FOLIAGE_COLOR : new SimpleColor(BiomeColors.getAverageFoliageColor((BlockAndTintGetter)l, (BlockPos)p));
    public static final Fixed EVERGREEN_FOLIAGE = new Fixed(new SimpleColor(FoliageColor.getEvergreenColor()));
    public static final Fixed BIRCH_FOLIAGE = new Fixed(new SimpleColor(FoliageColor.getBirchColor()));
    public static final Fixed MANGROVE_FOLIAGE = new Fixed(new SimpleColor(FoliageColor.getMangroveColor()));
    public static final BlockTintFunction WATER = (s, l, p, i) -> l == null || p == null ? null : new SimpleColorWithAlpha(BiomeColors.getAverageWaterColor((BlockAndTintGetter)l, (BlockPos)p));
    public static final KubeColor[] REDSTONE_COLORS = new KubeColor[16];
    public static final BlockTintFunction REDSTONE = (state, level, pos, index) -> {
        if (REDSTONE_COLORS[0] == null) {
            for (int i = 0; i < REDSTONE_COLORS.length; ++i) {
                BlockTintFunction.REDSTONE_COLORS[i] = new SimpleColor(RedStoneWireBlock.getColorForPower((int)i));
            }
        }
        return REDSTONE_COLORS[(Integer)state.getValue((Property)BlockStateProperties.POWER)];
    };

    public KubeColor getColor(BlockState var1, @Nullable BlockAndTintGetter var2, @Nullable BlockPos var3, int var4);

    @Nullable
    public static BlockTintFunction wrap(Context cx, Object o) {
        BlockTintFunction blockTintFunction;
        Object object = o;
        int n = 0;
        block27: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Undefined.class, Scriptable.class, BlockTintFunction.class, List.class, CharSequence.class, BaseFunction.class}, (Object)object, n)) {
                case -1: {
                    blockTintFunction = null;
                    break block27;
                }
                case 0: {
                    Undefined undefined = (Undefined)object;
                    blockTintFunction = null;
                    break block27;
                }
                case 1: {
                    Scriptable s = (Scriptable)object;
                    if (!Undefined.isUndefined((Object)s)) {
                        n = 2;
                        continue block27;
                    }
                    blockTintFunction = null;
                    break block27;
                }
                case 2: {
                    BlockTintFunction f = (BlockTintFunction)object;
                    blockTintFunction = f;
                    break block27;
                }
                case 3: {
                    List list = (List)object;
                    Mapped map = new Mapped();
                    for (int i = 0; i < list.size(); ++i) {
                        BlockTintFunction f = BlockTintFunction.wrap(cx, list.get(i));
                        if (f == null) continue;
                        map.map.put(i, (Object)f);
                    }
                    blockTintFunction = map;
                    break block27;
                }
                case 4: {
                    CharSequence cs = (CharSequence)object;
                    switch (cs.toString()) {
                        case "grass": {
                            blockTintFunction = GRASS;
                            break block27;
                        }
                        case "foliage": {
                            blockTintFunction = FOLIAGE;
                            break block27;
                        }
                        case "evergreen_foliage": {
                            blockTintFunction = EVERGREEN_FOLIAGE;
                            break block27;
                        }
                        case "birch_foliage": {
                            blockTintFunction = BIRCH_FOLIAGE;
                            break block27;
                        }
                        case "mangrove_foliage": {
                            blockTintFunction = MANGROVE_FOLIAGE;
                            break block27;
                        }
                        case "water": {
                            blockTintFunction = WATER;
                            break block27;
                        }
                        case "redstone": {
                            blockTintFunction = REDSTONE;
                            break block27;
                        }
                    }
                    blockTintFunction = new Fixed(ColorWrapper.wrap(o));
                    break block27;
                }
                case 5: {
                    BaseFunction function = (BaseFunction)object;
                    blockTintFunction = (BlockTintFunction)cx.createInterfaceAdapter(TYPE_INFO, (ScriptableObject)function);
                    break block27;
                }
                default: {
                    blockTintFunction = new Fixed(ColorWrapper.wrap(o));
                    break block27;
                }
            }
            break;
        }
        return blockTintFunction;
    }

    public static class Mapped
    implements BlockTintFunction {
        public final Int2ObjectMap<BlockTintFunction> map = new Int2ObjectArrayMap(1);

        @Override
        public KubeColor getColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
            BlockTintFunction f = (BlockTintFunction)this.map.get(index);
            return f == null ? null : f.getColor(state, level, pos, index);
        }
    }

    public record Fixed(KubeColor color) implements BlockTintFunction
    {
        @Override
        public KubeColor getColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
            return this.color;
        }
    }
}

