/*
 * Decompiled with CFR 0.152.
 */
package quilt.com.mrmelon54.DraggableLists;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_156;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import quilt.com.mrmelon54.DraggableLists.Cursor;
import quilt.com.mrmelon54.DraggableLists.DragItem;
import quilt.com.mrmelon54.DraggableLists.DragList;

public class DragManager<T, E extends class_4280.class_4281<?>> {
    private final DragList<T, E> dragList;
    private DragItem<T, E> selectedItem;
    private double draggingStartX = 0.0;
    private double draggingStartY = 0.0;
    private double draggingOffsetX = 0.0;
    private double draggingOffsetY = 0.0;
    private double softScrollingTimer = 0.0;
    private double softScrollingOrigin = 0.0;

    public DragManager(DragList<T, E> dragList) {
        this.dragList = dragList;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0 || this.selectedItem != null || !this.isCapMouseY((int)mouseY)) {
            return false;
        }
        this.selectedItem = this.dragList.draggable_lists$getEntryAtPosition(mouseX, mouseY);
        if (this.selectedItem == null) {
            return false;
        }
        this.draggingStartX = mouseX;
        this.draggingStartY = mouseY;
        this.draggingOffsetX = this.dragList.draggable_lists$getRowLeft() - this.draggingStartX;
        int entryIndex = this.dragList.draggable_lists$getIndexOfEntry(this.selectedItem);
        if (entryIndex < 0) {
            this.selectedItem = null;
            return false;
        }
        this.draggingOffsetY = (double)this.dragList.draggable_lists$getRowTop(entryIndex) - this.draggingStartY;
        if (this.draggingOffsetX > -32.0) {
            this.selectedItem = null;
            return false;
        }
        this.dragList.draggable_lists$setDragging(true);
        this.selectedItem.draggable_lists$getUnderlyingEntry().method_25365(true);
        this.selectedItem.draggable_lists$setBeingDragged(true);
        this.softScrollingTimer = 0.0;
        Cursor.setDragging();
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragList.draggable_lists$setDragging(false);
        if (this.selectedItem == null) {
            return false;
        }
        DragItem<T, E> selectedItem1 = this.selectedItem;
        this.selectedItem = null;
        this.softScrollingTimer = 0.0;
        Cursor.reset();
        double y = this.capYCoordinate((int)mouseY, true);
        selectedItem1.draggable_lists$setBeingDragged(false);
        DragItem<T, E> hoveredEntry = this.dragList.draggable_lists$getEntryAtPosition(mouseX, y);
        if (hoveredEntry == null) {
            return false;
        }
        T draggingData = selectedItem1.draggable_lists$getUnderlyingData();
        T hoveredData = hoveredEntry.draggable_lists$getUnderlyingData();
        return draggingData != null && hoveredData != null && draggingData != hoveredData && this.dragServerItem(selectedItem1, y);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.selectedItem != null;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.selectedItem != null;
    }

    public void renderListItems(class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        int rowLeft = (int)this.dragList.draggable_lists$getRowLeft();
        int rowWidth = this.dragList.draggable_lists$getRowWidth();
        int rowHeight = this.dragList.draggable_lists$getItemHeight() - 4;
        int n = this.dragList.draggable_lists$getItemCount();
        int draggingIndex = this.selectedItem == null ? -1 : this.dragList.draggable_lists$getIndexOfEntry(this.selectedItem);
        int draggedPosition = this.selectedItem == null ? -1 : this.getIndexFromMouseY(mouseY);
        for (int i = 0; i < n; ++i) {
            int renderRow = this.otherItemIndexShift(i, draggingIndex, draggedPosition);
            int rowTop = this.dragList.draggable_lists$getRowTop(renderRow);
            int rowBottom = this.dragList.draggable_lists$getRowBottom(renderRow);
            if (rowBottom < this.dragList.draggable_lists$getY() || rowTop > this.dragList.draggable_lists$getBottom() || i == draggingIndex) continue;
            this.dragList.draggable_lists$renderItem(guiGraphics, mouseX, mouseY, tickDelta, i, rowLeft, rowTop, rowWidth, rowHeight);
        }
    }

    private int otherItemIndexShift(int i, int draggingIndex, int draggedPosition) {
        if (i == draggingIndex) {
            return draggedPosition;
        }
        if (draggingIndex < draggedPosition) {
            return i >= draggingIndex && i <= draggedPosition ? i - 1 : i;
        }
        return i >= draggedPosition && i <= draggingIndex ? i + 1 : i;
    }

    public void renderWidget(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.selectedItem == null) {
            return;
        }
        int z = class_3532.method_15357((double)((double)mouseY + this.draggingOffsetY));
        int x = class_3532.method_15357((double)(this.draggingStartX + this.draggingOffsetX));
        int y = this.capYCoordinate(z);
        int entryHeight = this.dragList.draggable_lists$getItemHeight() - 4;
        int entryWidth = this.dragList.draggable_lists$getRowWidth();
        guiGraphics.method_51448().method_22903();
        float shaderColorValue = 0.7490196f;
        RenderSystem.setShaderColor((float)shaderColorValue, (float)shaderColorValue, (float)shaderColorValue, (float)0.5f);
        guiGraphics.method_25294(x - 1, y - 1, x + entryWidth - 2, y + entryHeight + 1, -1077952513);
        this.selectedItem.draggable_lists$render(guiGraphics, 0, y, x, entryWidth, entryHeight, mouseX, mouseY, false, delta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_22909();
        if (y < z) {
            if (this.softScrollingTimer == 0.0) {
                this.softScrollingTimer = class_156.method_658();
                this.softScrollingOrigin = this.dragList.draggable_lists$getScrollAmount();
            }
            float f = (float)((double)class_156.method_658() - this.softScrollingTimer) / 5.0f;
            this.dragList.draggable_lists$setScrollAmount(this.softScrollingOrigin + (double)f);
        } else if (y > z) {
            if (this.softScrollingTimer == 0.0) {
                this.softScrollingTimer = class_156.method_658();
                this.softScrollingOrigin = this.dragList.draggable_lists$getScrollAmount();
            }
            float f = (float)((double)class_156.method_658() - this.softScrollingTimer) / 5.0f;
            this.dragList.draggable_lists$setScrollAmount(this.softScrollingOrigin - (double)f);
        } else {
            this.softScrollingTimer = 0.0;
        }
    }

    private int capYCoordinate(int y, boolean useScreenSpace) {
        int scrollableTop = this.dragList.draggable_lists$getY() + 4;
        int scrollableHeight = this.dragList.draggable_lists$getBottom() - this.dragList.draggable_lists$getY() - (useScreenSpace ? 2 : this.dragList.draggable_lists$getItemHeight() + 2);
        if (y < scrollableTop) {
            y = scrollableTop;
        }
        if (y > scrollableTop + scrollableHeight) {
            y = scrollableTop + scrollableHeight;
        }
        return y;
    }

    private int capYCoordinate(int y) {
        return this.capYCoordinate(y, false);
    }

    private boolean isCapMouseY(int y) {
        return this.capYCoordinate(y, true) == y;
    }

    private int getIndexFromMouseY(double mouseY) {
        int m = class_3532.method_15357((double)(mouseY - (double)this.dragList.draggable_lists$getY())) - this.dragList.draggable_lists$getHeaderHeight() + (int)this.dragList.draggable_lists$getScrollAmount() - 4;
        return m / this.dragList.draggable_lists$getItemHeight();
    }

    private boolean dragServerItem(DragItem<T, E> item, double mouseY) {
        int n = this.getIndexFromMouseY(mouseY);
        this.dragList.draggable_lists$moveEntry(item, n);
        return true;
    }
}

