/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.mrmelon54.DraggableLists.mixin.server;

import neoforge.com.mrmelon54.DraggableLists.DragItem;
import neoforge.com.mrmelon54.DraggableLists.DragList;
import neoforge.com.mrmelon54.DraggableLists.DragManager;
import neoforge.com.mrmelon54.DraggableLists.duck.ServerListDuckProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ServerSelectionList.class})
public abstract class ServerSelectionListMixin
extends ObjectSelectionList<ServerSelectionList.Entry>
implements DragList<ServerData, ServerSelectionList.OnlineServerEntry> {
    @Shadow
    @Final
    private JoinMultiplayerScreen screen;
    @Unique
    private final DragManager<ServerData, ServerSelectionList.OnlineServerEntry> draggable_lists$dragManager = new DragManager<ServerData, ServerSelectionList.OnlineServerEntry>(this);

    @Shadow
    public abstract void setSelected(@Nullable ServerSelectionList.Entry var1);

    @Shadow
    public abstract void updateOnlineServers(ServerList var1);

    @Shadow
    public abstract int getRowWidth();

    public ServerSelectionListMixin(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
        super(minecraftClient, i, j, k, l);
    }

    protected void renderListItems(GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        this.draggable_lists$dragManager.renderListItems(guiGraphics, mouseX, mouseY, tickDelta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.draggable_lists$dragManager.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.draggable_lists$dragManager.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.draggable_lists$dragManager.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.draggable_lists$dragManager.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(guiGraphics, mouseX, mouseY, delta);
        this.draggable_lists$dragManager.renderWidget(guiGraphics, mouseX, mouseY, delta);
    }

    @Override
    public DragItem<ServerData, ServerSelectionList.OnlineServerEntry> draggable_lists$getEntryAtPosition(double mouseX, double mouseY) {
        ServerSelectionList.Entry entryAtPosition = (ServerSelectionList.Entry)this.getEntryAtPosition(mouseX, mouseY);
        if (entryAtPosition instanceof ServerSelectionList.OnlineServerEntry) {
            ServerSelectionList.OnlineServerEntry onlineServerEntry = (ServerSelectionList.OnlineServerEntry)entryAtPosition;
            return (DragItem)onlineServerEntry;
        }
        return null;
    }

    @Override
    public int draggable_lists$getIndexOfEntry(DragItem<ServerData, ServerSelectionList.OnlineServerEntry> selectedItem) {
        return this.children().indexOf(selectedItem.draggable_lists$getUnderlyingEntry());
    }

    @Override
    public void draggable_lists$setDragging(boolean b) {
        super.setDragging(b);
    }

    @Override
    public int draggable_lists$getHeaderHeight() {
        return this.headerHeight;
    }

    @Override
    public int draggable_lists$getY() {
        return this.getY();
    }

    @Override
    public int draggable_lists$getBottom() {
        return this.getBottom();
    }

    @Override
    public int draggable_lists$getItemHeight() {
        return this.itemHeight;
    }

    @Override
    public int draggable_lists$getRowTop(int i) {
        return this.getRowTop(i);
    }

    @Override
    public int draggable_lists$getRowBottom(int i) {
        return this.getRowBottom(i);
    }

    @Override
    public double draggable_lists$getRowLeft() {
        return this.getRowLeft();
    }

    @Override
    public int draggable_lists$getRowWidth() {
        return this.getRowWidth();
    }

    @Override
    public double draggable_lists$getScrollAmount() {
        return this.getScrollAmount();
    }

    @Override
    public void draggable_lists$setScrollAmount(double v) {
        this.setScrollAmount(v);
    }

    @Override
    public void draggable_lists$moveEntry(DragItem<ServerData, ServerSelectionList.OnlineServerEntry> item, int n) {
        ServerList servers = this.screen.getServers();
        if (servers instanceof ServerListDuckProvider) {
            ServerListDuckProvider duckProvider = (ServerListDuckProvider)servers;
            duckProvider.draggable_lists$moveItem(item, n);
            servers.save();
            this.updateOnlineServers(servers);
        }
    }

    @Override
    public int draggable_lists$getItemCount() {
        return this.getItemCount();
    }

    @Override
    public void draggable_lists$renderItem(GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta, int i, int rowLeft, int rowTop, int rowWidth, int rowHeight) {
        this.renderItem(guiGraphics, mouseX, mouseY, tickDelta, i, rowLeft, rowTop, rowWidth, rowHeight);
    }
}

