/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets.text;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class AutoScaledStringWidget
extends StringWidget {
    private float scale = 1.0f;
    private float autoScale = 1.0f;
    private float halign;
    private float valign = 0.5f;
    private boolean clip;
    private boolean fit;

    public AutoScaledStringWidget(Component component, Font font) {
        super(component, font);
    }

    public AutoScaledStringWidget(int i, int j, Component component, Font font) {
        super(i, j, component, font);
    }

    public AutoScaledStringWidget(int i, int j, int k, int l, Component component, Font font) {
        super(i, j, k, l, component, font);
    }

    public void setMessage(Component component) {
        int w = this.getWidth();
        int h = this.getHeight();
        int cw = this.getFont().width((FormattedText)component);
        Objects.requireNonNull(this.getFont());
        int ch = 9;
        this.autoScale = Math.min(cw > w ? (float)w / (float)cw : 1.0f, ch > h ? (float)h / (float)ch : 1.0f);
        super.setMessage(component);
    }

    public boolean getClip() {
        return this.clip;
    }

    public boolean getFit() {
        return this.fit;
    }

    public float getScale() {
        return this.scale;
    }

    public float getHAlign() {
        return this.halign;
    }

    public float setVAlign() {
        return this.valign;
    }

    public void setClip(boolean clip) {
        this.clip = clip;
    }

    public void setFit(boolean fit) {
        this.fit = fit;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setHAlign(float halign) {
        this.halign = halign;
    }

    public void setVAlign(float valign) {
        this.valign = valign;
    }

    public AutoScaledStringWidget clipped(boolean clip) {
        this.setClip(clip);
        return this;
    }

    public AutoScaledStringWidget fitting(boolean fit) {
        this.setFit(fit);
        return this;
    }

    public AutoScaledStringWidget scaled(float scale) {
        this.setScale(scale);
        return this;
    }

    public AutoScaledStringWidget alignCenter() {
        this.halign = 0.5f;
        this.valign = 0.5f;
        return this;
    }

    public AutoScaledStringWidget alignLeft() {
        this.halign = 0.0f;
        return this;
    }

    public AutoScaledStringWidget alignRight() {
        this.halign = 1.0f;
        return this;
    }

    public AutoScaledStringWidget alignTop() {
        this.valign = 0.0f;
        return this;
    }

    public AutoScaledStringWidget alignBottom() {
        this.valign = 1.0f;
        return this;
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        boolean clip = this.clip;
        float scale = this.fit ? this.scale * this.autoScale : this.scale;
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (clip) {
            guiGraphics.enableScissor(x, y, x + w, y + h);
        }
        guiGraphics.pose().pushPose();
        PoseStack poseStack = guiGraphics.pose();
        float f2 = (float)x + ((float)w - (float)this.getFont().width((FormattedText)this.getMessage()) * scale) * this.halign;
        float f3 = y;
        float f4 = h;
        Objects.requireNonNull(this.getFont());
        poseStack.translate(f2, f3 + (f4 - 9.0f * scale) * this.valign, 0.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.pose().translate((float)(-x), (float)(-y), 0.0f);
        guiGraphics.drawString(this.getFont(), this.getMessage(), x, y, this.getColor());
        guiGraphics.pose().popPose();
        if (clip) {
            guiGraphics.disableScissor();
        }
    }
}

