/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.ArrUtils;
import com.gitlab.srcmc.rctmod.client.renderer.TargetArrowRenderer;
import com.gitlab.srcmc.rctmod.client.renderer.TrainerAssociationRenderer;
import com.gitlab.srcmc.rctmod.client.renderer.TrainerRenderer;
import com.gitlab.srcmc.rctmod.client.screens.IScreenManager;
import com.gitlab.srcmc.rctmod.client.screens.ScreenManager;
import com.gitlab.srcmc.rctmod.network.BatchedPayload;
import com.gitlab.srcmc.rctmod.network.BatchedPayloads;
import com.gitlab.srcmc.rctmod.network.TrainerTargetPayload;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ModClient {
    public static final DataPackManager RESOURCE_MANAGER = new DataPackManager(PackType.CLIENT_RESOURCES);
    public static final IScreenManager SCREENS = new ScreenManager();
    private static final Queue<byte[]> playerStateUpdates = new ConcurrentLinkedDeque<byte[]>();
    private static final Queue<BatchedPayload.Payload[]> trainerManagerUpdates = new ConcurrentLinkedDeque<BatchedPayload.Payload[]>();
    static List<byte[]> PLAYER_STATE_PAYLOADS = new ArrayList<byte[]>();
    static List<BatchedPayload.Payload> TRAINER_MANAGER_PAYLOADS = new ArrayList<BatchedPayload.Payload>();

    public static void registerEventHandlers() {
        ClientTickEvent.CLIENT_LEVEL_POST.register(ModClient::onClientLevelTick);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(ModClient::onClientPlayerJoin);
    }

    public static void init() {
        Minecraft mc = Minecraft.getInstance();
        ModCommon.initPlayer(() -> mc.player);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)RESOURCE_MANAGER);
        EntityRendererRegistry.register(ModRegistries.Entities.TRAINER, TrainerRenderer::new);
        EntityRendererRegistry.register(ModRegistries.Entities.TRAINER_ASSOCIATION, TrainerAssociationRenderer::new);
    }

    public static void setup() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, BatchedPayloads.PLAYER_STATE.TYPE, BatchedPayloads.PLAYER_STATE.CODEC, ModClient::receivePlayerState);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, BatchedPayloads.TRAINER_MANAGER.TYPE, BatchedPayloads.TRAINER_MANAGER.CODEC, ModClient::receiveTrainerManager);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, TrainerTargetPayload.TYPE, TrainerTargetPayload.CODEC, ModClient::receiveTrainerTarget);
    }

    static void onClientLevelTick(Level level) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        if (!trainerManagerUpdates.isEmpty()) {
            tm.fromPayloads(trainerManagerUpdates.poll());
        }
        if (!tm.isLoading() && !playerStateUpdates.isEmpty()) {
            PlayerState.get(ModCommon.localPlayer()).deserializeUpdate(playerStateUpdates.poll());
        }
        TargetArrowRenderer.getInstance().tick();
    }

    static void onClientPlayerJoin(LocalPlayer player) {
        PLAYER_STATE_PAYLOADS.clear();
        TRAINER_MANAGER_PAYLOADS.clear();
        RCTMod.getInstance().getTrainerManager().setLoading(true);
        PlayerState.initFor((Player)player);
    }

    static void receivePlayerState(BatchedPayload.Payload pl, NetworkManager.PacketContext context) {
        PlayerState.get(ModCommon.localPlayer()).setLoading();
        PLAYER_STATE_PAYLOADS.add(pl.bytes());
        if (pl.remainingBatches() == 0) {
            if (!playerStateUpdates.offer(ArrUtils.combine(PLAYER_STATE_PAYLOADS))) {
                ModCommon.LOG.error("Failed to store player state updates");
            }
            PLAYER_STATE_PAYLOADS.clear();
        }
    }

    static void receiveTrainerManager(BatchedPayload.Payload pl, NetworkManager.PacketContext context) {
        RCTMod.getInstance().getTrainerManager().setLoading(true);
        TRAINER_MANAGER_PAYLOADS.add(pl);
        if (pl.remainingBatches() == 0) {
            if (!trainerManagerUpdates.offer(TRAINER_MANAGER_PAYLOADS.toArray(new BatchedPayload.Payload[TRAINER_MANAGER_PAYLOADS.size()]))) {
                ModCommon.LOG.error("Failed to store trainer manager updates");
            }
            TRAINER_MANAGER_PAYLOADS.clear();
        }
    }

    static void receiveTrainerTarget(TrainerTargetPayload tt, NetworkManager.PacketContext context) {
        TargetArrowRenderer.getInstance().setTarget((Entity)context.getPlayer(), new Vec3(tt.targetX(), tt.targetY(), tt.targetZ()), tt.otherDim());
    }
}

