/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.service;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import com.gitlab.srcmc.rctapi.api.errors.RCTException;
import com.gitlab.srcmc.rctapi.api.models.TrainerModel;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.TrainerBattle;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemory;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.utils.PathUtils;
import com.gitlab.srcmc.rctmod.network.BatchedPayload;
import com.gitlab.srcmc.rctmod.network.BatchedPayloads;
import com.gitlab.srcmc.rctmod.server.ModServer;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.google.gson.JsonElement;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class TrainerManager
extends DataPackManager {
    private Map<String, TrainerMobData> trainerMobs = new HashMap<String, TrainerMobData>();
    private SeriesManager seriesManager;
    private Queue<Thread> payloadUpdateThreads = new ConcurrentLinkedDeque<Thread>();
    private Map<UUID, String> uuidToTrainerId = new HashMap<UUID, String>();
    private Set<String> playerTrainerIds = new HashSet<String>();
    private Set<Player> receivedUpdates = new HashSet<Player>();
    private Map<UUID, TrainerBattle> trainerBattles = new HashMap<UUID, TrainerBattle>();
    private Queue<Runnable> onLoadedHandlers = new LinkedList<Runnable>();
    private MinecraftServer server;
    private ResourceManager resourceManager;
    private boolean loading;
    private boolean isReloadedAsDatapack;
    private boolean reloadRequired;

    public TrainerManager() {
        super(PackType.SERVER_DATA);
        this.seriesManager = new SeriesManager();
    }

    public void runAfterLoaded(Runnable f) {
        if (!this.isReloadRequired() || !this.isLoading()) {
            f.run();
        } else {
            this.onLoadedHandlers.offer(f);
        }
    }

    public void setLoading(boolean value) {
        boolean bl = this.loading = !this.isReloadedAsDatapack && value;
        if (this.server != null && !this.loading && !this.reloadRequired) {
            this.server.execute(() -> {
                while (!this.onLoadedHandlers.isEmpty()) {
                    this.onLoadedHandlers.poll().run();
                }
            });
        }
    }

    public void setIsReloadedAsDatapack(boolean value) {
        this.isReloadedAsDatapack = value;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void fromPayloads(BatchedPayload.Payload[] pls) {
        Thread t = new Thread(() -> {
            TrainerType.clear();
            Payload pl = (Payload)BatchedPayloads.TRAINER_MANAGER.from(pls);
            this.trainerMobs = pl.trainerMobs();
            this.seriesManager.copyFrom(pl.seriesManager());
            this.payloadUpdateThreads.poll();
            if (!this.payloadUpdateThreads.isEmpty()) {
                this.payloadUpdateThreads.peek().start();
            } else {
                this.setLoading(false);
            }
        });
        t.setPriority(2);
        this.payloadUpdateThreads.add(t);
        if (this.payloadUpdateThreads.size() == 1) {
            t.start();
        }
    }

    public BatchedPayload.Payload[] toPayloads() {
        return BatchedPayloads.TRAINER_MANAGER.payloads(new Payload(this.trainerMobs, this.seriesManager));
    }

    public SeriesManager getSeriesManager() {
        return this.seriesManager;
    }

    public void setServer(MinecraftServer server) {
        if (server != null) {
            BattleManager bm = ModCommon.RCT.getBattleManager();
            bm.getStates().stream().toList().forEach(bs -> bm.end(bs.getBattle().getBattleId(), true));
            ModCommon.RCT.getTrainerRegistry().init(server);
        }
        this.server = server;
    }

    public boolean isReloadRequired() {
        return this.reloadRequired && this.resourceManager != null;
    }

    public void setReloadRequired() {
        this.reloadRequired = true;
    }

    private void registerTrainer(String trainerId, TrainerMobData tmd, Map<String, Trainer> oldTrainers) {
        if (this.server != null && this.server.isSameThread()) {
            TrainerRegistry reg = ModCommon.RCT.getTrainerRegistry();
            try {
                TrainerNPC newTrainer = reg.registerNPC(trainerId, (TrainerModel)tmd.getTrainerTeam());
                Trainer oldTrainer = oldTrainers.get(trainerId);
                if (oldTrainer != null) {
                    newTrainer.setEntity(oldTrainer.getEntity());
                }
            }
            catch (RCTException errors) {
                ModCommon.LOG.warn("Model validation failure for '" + trainerId + "'" + errors.getErrors().stream().map(e -> e.message).reduce("", (a, b) -> a + "\n  " + b));
            }
            catch (Exception e2) {
                ModCommon.LOG.error("Failed to register trainer '" + trainerId + "'", (Throwable)e2);
            }
        }
    }

    public String registerPlayer(Player player) {
        String trainerId = this.uuidToTrainerId.get(player.getUUID());
        if (trainerId == null) {
            String name;
            int attempt = 0;
            trainerId = name = player.getName().getString().replace(' ', '_');
            while (this.playerTrainerIds.contains(trainerId)) {
                trainerId = String.format("%s_%d", name, ++attempt);
            }
            this.uuidToTrainerId.put(player.getUUID(), trainerId);
            this.playerTrainerIds.add(trainerId);
        }
        return trainerId;
    }

    public String unregisterPlayer(Player player) {
        String trainerId = this.uuidToTrainerId.remove(player.getUUID());
        if (trainerId != null) {
            this.playerTrainerIds.remove(trainerId);
        }
        return trainerId;
    }

    public String getTrainerId(Player player) {
        if (!this.uuidToTrainerId.containsKey(player.getUUID())) {
            this.registerPlayer(player);
        }
        return this.uuidToTrainerId.get(player.getUUID());
    }

    public void addBattle(Player initiator, TrainerMob opponent) {
        this.trainerBattles.put(initiator.getUUID(), new TrainerBattle(initiator, opponent));
    }

    public void addBattle(Player[] initiatorSidePlayers, TrainerMob[] initiatorSideMobs, Player[] trainerSidePlayers, TrainerMob[] trainerSideMobs) {
        TrainerBattle battle = new TrainerBattle(initiatorSidePlayers, initiatorSideMobs, trainerSidePlayers, trainerSideMobs);
        this.trainerBattles.put(battle.getInitiator().getUUID(), battle);
    }

    public Optional<TrainerBattle> getBattle(UUID initiatorId) {
        return this.trainerBattles.containsKey(initiatorId) ? Optional.of(this.trainerBattles.get(initiatorId)) : Optional.empty();
    }

    public boolean removeBattle(UUID initiatorId) {
        return this.trainerBattles.remove(initiatorId) != null;
    }

    public TrainerMobData getData(TrainerMob mob) {
        return this.getData(mob.getTrainerId());
    }

    public TrainerMobData getData(String trainerId) {
        if (!this.trainerMobs.containsKey(trainerId)) {
            return new TrainerMobData();
        }
        return this.trainerMobs.get(trainerId);
    }

    public boolean isValidId(String trainerId) {
        return this.trainerMobs.containsKey(trainerId);
    }

    public int getPlayerLevel(Player player) {
        int maxLevel = 0;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (Pokemon pk : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
                maxLevel = Math.max(maxLevel, pk.getLevel());
            }
        }
        return maxLevel;
    }

    public int getActivePokemon(Player player) {
        int count = 0;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (Pokemon pk : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
                if (pk.isFainted()) continue;
                ++count;
            }
        }
        return count;
    }

    public TrainerPlayerData getData(Player player) {
        TrainerPlayerData.Builder builder = new TrainerPlayerData.Builder(player);
        return ((TrainerPlayerData)player.getServer().overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(builder::create, builder::of, DataFixTypes.LEVEL), TrainerPlayerData.filePath(player))).forPlayer(player);
    }

    public Stream<Map.Entry<String, TrainerMobData>> getAllData(String ... series) {
        return series.length > 0 ? this.trainerMobs.entrySet().stream().filter(e -> Stream.of(series).anyMatch(s -> ((TrainerMobData)e.getValue()).isOfSeries((String)s))) : this.trainerMobs.entrySet().stream();
    }

    public TrainerBattleMemory getBattleMemory(TrainerMob mob) {
        return this.getBattleMemory(mob.getServer().overworld(), mob.getTrainerId());
    }

    public TrainerBattleMemory getBattleMemory(ServerLevel level, String trainerId) {
        DimensionDataStorage dds = level.getServer().overworld().getDataStorage();
        TrainerBattleMemory.Version ver = TrainerBattleMemory.getVersion(dds);
        if (ver.isOutdated()) {
            TrainerBattleMemory.migrate(this.server, RCTMod.getInstance().getTrainerManager());
        }
        return (TrainerBattleMemory)dds.computeIfAbsent(new SavedData.Factory(TrainerBattleMemory::new, TrainerBattleMemory::of, DataFixTypes.LEVEL), TrainerBattleMemory.filePath(trainerId, ver));
    }

    public boolean updateRequired(Player player) {
        return this.receivedUpdates.add(player);
    }

    public boolean requiresUpdate(Player player) {
        return this.receivedUpdates.remove(player);
    }

    public void loadTrainers() {
        this.forceReload(this.resourceManager);
    }

    protected void forceReload(ResourceManager resourceManager) {
        this.reloadRequired = false;
        this.reload(resourceManager);
        HashMap oldTrainers = new HashMap();
        HashMap<String, TrainerMobData> newTrainerMobs = new HashMap<String, TrainerMobData>();
        TrainerRegistry reg = ModCommon.RCT.getTrainerRegistry();
        reg.getIds().stream().map(tid -> Map.entry(tid, reg.getById(tid))).filter(entry -> entry.getValue() instanceof TrainerNPC).forEach(entry -> oldTrainers.put((String)entry.getKey(), (Trainer)entry.getValue()));
        reg.clearNPCs();
        this.listTrainerTeams((rl, io) -> {
            String trainerId = PathUtils.filename(rl.getPath());
            this.loadResource(trainerId, "mobs", (T tmd) -> {
                newTrainerMobs.put(trainerId, (TrainerMobData)tmd);
                this.registerTrainer(trainerId, (TrainerMobData)tmd, oldTrainers);
            }, TrainerMobData.class);
        });
        newTrainerMobs.forEach((trainerId, tmd) -> tmd.getMissingRequirements(Set.of(), true).forEach(tid -> {
            TrainerMobData tmd2 = (TrainerMobData)newTrainerMobs.get(tid);
            if (tmd2 == null) return;
            if (!tmd.getSeries().findAny().isEmpty()) {
                if (!tmd.getSeries().anyMatch(tmd2::isOfSeries)) {
                    ModCommon.LOG.warn(String.format("trainer '%s' may not depend on '%s': different series", trainerId, tid));
                    return;
                }
            }
            tmd2.addFollowedBy((String)trainerId);
        }));
        this.trainerMobs = newTrainerMobs;
        this.seriesManager.onLoad(this);
        this.receivedUpdates = new HashSet<Player>();
        this.close();
        ModServer.syncTrainerManger(this.server.getPlayerList().getPlayers());
        this.setLoading(false);
        ModCommon.LOG.info(String.format("Registered %d trainers", this.trainerMobs.size()));
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.resourceManager = resourceManager;
        this.setReloadRequired();
    }

    record Payload(Map<String, TrainerMobData> trainerMobs, SeriesManager seriesManager) implements Serializable
    {
        private static final long serialVersionUID = 0L;
    }
}

