/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.util.UnsafeBoundingBox;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchPiece;
import org.jetbrains.annotations.NotNull;

public class ArchStructure
extends Structure {
    public static final BoundingBox INFINITE = BoundingBox.infinite();
    public static final MapCodec<ArchStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ArchStructure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)ArchConfig.CODEC.fieldOf("config").forGetter(archStructure -> archStructure.config)).apply((Applicative)builder, ArchStructure::new));
    private final ArchConfig config;

    public ArchStructure(Structure.StructureSettings settings, ArchConfig config) {
        super(settings);
        this.config = config;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> findGenerationPoint(@NotNull Structure.GenerationContext context) {
        return ArchStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, structurePiecesBuilder -> {
            ChunkPos chunkPos = context.chunkPos();
            WorldgenRandom random = context.random();
            int blockX = chunkPos.getBlockX(random.nextInt(16));
            int blockZ = chunkPos.getBlockZ(random.nextInt(16));
            ChunkGenerator chunkGenerator = context.chunkGenerator();
            int blockY = chunkGenerator.getBaseHeight(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
            int yOffset = this.config.height().sample((RandomSource)random);
            BlockPos structureCenter = new BlockPos(blockX, blockY, blockZ);
            Vec3 originVec3 = Vec3.atCenterOf((Vec3i)structureCenter);
            BlockPos offset = new BlockPos(this.config.length().sample((RandomSource)random) / 2 * (random.nextBoolean() ? 1 : -1), 0, this.config.length().sample((RandomSource)random) / 2 * (random.nextBoolean() ? 1 : -1));
            BlockPos first = structureCenter.offset((Vec3i)offset);
            first = first.atY(chunkGenerator.getBaseHeight(first.getX(), first.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState()) - 10);
            Vec3 firstVec3 = Vec3.atCenterOf((Vec3i)first);
            BlockPos second = structureCenter.subtract((Vec3i)offset);
            second = second.atY(chunkGenerator.getBaseHeight(second.getX(), second.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState()) - 10);
            Vec3 secondVec3 = Vec3.atCenterOf((Vec3i)second);
            Long2ObjectOpenHashMap generatingChunks = new Long2ObjectOpenHashMap();
            Consumer<BlockPos> stepAction = position -> ((UnsafeBoundingBox)generatingChunks.computeIfAbsent(ChunkPos.asLong((BlockPos)position), key -> new UnsafeBoundingBox())).encapsulate((Vec3i)position);
            this.config.archGeneratorConfig().generate(context.seed() + structureCenter.asLong(), yOffset, firstVec3, originVec3, secondVec3, INFINITE, stepAction);
            BlockPos finalFirst = first;
            BlockPos finalSecond = second;
            generatingChunks.long2ObjectEntrySet().fastForEach(unsafeBoundingBoxEntry -> structurePiecesBuilder.addPiece((StructurePiece)new ArchPiece(((UnsafeBoundingBox)unsafeBoundingBoxEntry.getValue()).toBoundingBox(), structureCenter, finalFirst, finalSecond, yOffset, this.config.archGeneratorConfig(), this.config.checkedBlockPlacement())));
        });
    }

    public static void between(Vec3 center, Vec3 second, double xzStepDistance, int yOffset, double step3dDistance, BlendingFunction blendingFunction, Consumer<BlockPos> stepAction) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Vec3 xzDifference = center.subtract(second);
        double xzDistance = xzDifference.horizontalDistance();
        double xzTotalSteps = xzDistance / xzStepDistance;
        int step = 0;
        while ((double)step < xzTotalSteps) {
            double factor = (double)step / xzTotalSteps;
            Vec3 stepVec3 = center.add(xzDifference.normalize().scale((double)step * xzStepDistance));
            double yPos = blendingFunction.apply(1.0 - factor, second.y, center.y + (double)yOffset);
            Vec3 stepVec3YOffset = new Vec3(stepVec3.x, yPos, stepVec3.z);
            int nextStep = step + 1;
            double nextFactor = (double)nextStep / xzTotalSteps;
            Vec3 nextStepVec3 = center.add(xzDifference.normalize().scale((double)nextStep * xzStepDistance));
            double nextYPos = blendingFunction.apply(1.0 - nextFactor, second.y, center.y + (double)yOffset);
            Vec3 nextStepVec3YOffset = new Vec3(nextStepVec3.x, nextYPos, nextStepVec3.z);
            ArchStructure.between3D(step3dDistance, nextStepVec3YOffset, stepVec3YOffset, mutableBlockPos, stepAction);
            ++step;
        }
    }

    private static void between3D(double step3dDistance, Vec3 nextStepVec3YOffset, Vec3 stepVec3YOffset, BlockPos.MutableBlockPos mutableBlockPos, Consumer<BlockPos> stepAction) {
        Vec3 difference3D = nextStepVec3YOffset.subtract(stepVec3YOffset);
        double distance3d = difference3D.length();
        double totalSteps3D = distance3d / step3dDistance;
        int step3D = 0;
        while ((double)step3D <= totalSteps3D) {
            Vec3 step3DVec3 = stepVec3YOffset.add(difference3D.normalize().scale((double)step3D * step3dDistance));
            mutableBlockPos.set(step3DVec3.x, step3DVec3.y, step3DVec3.z);
            stepAction.accept(mutableBlockPos.immutable());
            ++step3D;
        }
    }

    public static void generate(long seed, double thickness, double frequency, BlockPos stepOrigin, BoundingBox effectedArea, Consumer<BlockPos> action) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ImprovedNoise noise = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(seed));
        if (!effectedArea.equals((Object)INFINITE) && !effectedArea.inflatedBy((int)thickness + 1).isInside((Vec3i)stepOrigin)) {
            return;
        }
        for (double x = -thickness; x <= thickness; x += 1.0) {
            for (double y = -thickness; y <= thickness; y += 1.0) {
                for (double z = -thickness; z <= thickness; z += 1.0) {
                    mutableBlockPos.setWithOffset((Vec3i)stepOrigin, (int)x, (int)y, (int)z);
                    if (!effectedArea.equals((Object)INFINITE) && !effectedArea.isInside((Vec3i)mutableBlockPos) || !(stepOrigin.distSqr((Vec3i)mutableBlockPos) < Mth.square((double)thickness))) continue;
                    double noiseSample = (noise.noise((double)mutableBlockPos.getX() * frequency, (double)mutableBlockPos.getY() * frequency, (double)mutableBlockPos.getZ() * frequency) + 1.0) * 0.5;
                    double localRadius = Mth.clampedLerp((double)(thickness * 0.5), (double)thickness, (double)noiseSample);
                    if (!(stepOrigin.distSqr((Vec3i)mutableBlockPos) < Mth.square((double)localRadius))) continue;
                    action.accept((BlockPos)mutableBlockPos);
                }
            }
        }
    }

    @NotNull
    public StructureType<?> type() {
        return BWGStructureTypes.ARCH.get();
    }
}

