/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.mixins;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.amendments.common.ExtendedHangingSign;
import net.mehvahdjukaar.amendments.common.network.ClientBoundEntityHitSwayingBlockMessage;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.HangingSignDisplayItem;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/world/level/block/WallHangingSignBlock", "net/minecraft/world/level/block/CeilingHangingSignBlock"})
public abstract class CeilingHangingSignBlockMixin
extends Block
implements EntityBlock {
    protected CeilingHangingSignBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"updateShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")})
    public void amendments$updateExtension(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos, CallbackInfoReturnable<BlockState> cir) {
        BlockEntity blockEntity = level.getBlockEntity(currentPos);
        if (blockEntity instanceof ExtendedHangingSign) {
            ExtendedHangingSign tile = (ExtendedHangingSign)blockEntity;
            tile.amendments$getExtension().updateShape(state, direction, neighborState, level, currentPos, neighborPos);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExtendedHangingSign) {
            ExtendedHangingSign tile = (ExtendedHangingSign)blockEntity;
            tile.amendments$getExtension().updateAttachments(level, pos, state);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ExtendedHangingSign tile;
        super.entityInside(state, level, pos, entity);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExtendedHangingSign && (tile = (ExtendedHangingSign)blockEntity).amendments$getExtension().canSwing()) {
            if (level.isClientSide) {
                tile.amendments$getExtension().getClientAnimation().hitByEntity(entity, state, pos);
            } else {
                if (entity.xo != entity.getX() || entity.zo != entity.getZ() || entity.yo != entity.getY()) {
                    level.gameEvent(entity, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
                }
                NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new ClientBoundEntityHitSwayingBlockMessage(pos, entity.getId()));
            }
        }
    }

    @WrapMethod(method={"getTicker(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntityType;)Lnet/minecraft/world/level/block/entity/BlockEntityTicker;"})
    private <T extends BlockEntity> BlockEntityTicker<T> amendments$swingSign(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType, Operation<BlockEntityTicker<T>> original) {
        BlockEntityTicker ticker = (BlockEntityTicker)original.call(new Object[]{pLevel, pState, pBlockEntityType});
        if (ticker == null && !pLevel.isClientSide) {
            return null;
        }
        return (level, blockPos, blockState, blockEntity) -> {
            if (ticker != null) {
                ticker.tick(level, blockPos, blockState, blockEntity);
            }
            if (level.isClientSide && ClientConfigs.SWINGING_SIGNS.get().booleanValue() && blockEntity instanceof ExtendedHangingSign) {
                ExtendedHangingSign te = (ExtendedHangingSign)blockEntity;
                te.amendments$getExtension().clientTick(level, blockPos, blockState);
            }
        };
    }

    @Inject(method={"useItemOn(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/ItemInteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    public void amendments$use(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<ItemInteractionResult> cir) {
        InteractionResult ret = HangingSignDisplayItem.INSTANCE.tryPerformingAction(state, pos, level, player, hand, player.getItemInHand(hand), hit);
        if (ret != InteractionResult.PASS) {
            cir.setReturnValue((Object)ItemInteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(super.getDrops(state, params));
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof ExtendedHangingSign) {
            ItemStack frontItem;
            ExtendedHangingSign tile = (ExtendedHangingSign)object;
            ItemStack backItem = tile.amendments$getExtension().getBackItem();
            if (!backItem.isEmpty()) {
                list.add(backItem);
            }
            if (!(frontItem = tile.amendments$getExtension().getFrontItem()).isEmpty()) {
                list.add(frontItem);
            }
        }
        return list;
    }
}

