/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.broadcast;

import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.api.broadcast.Broadcast;
import us.timinc.mc.cobblemon.spawnnotification.api.broadcast.BroadcastContext;
import us.timinc.mc.cobblemon.spawnnotification.api.broadcast.BroadcastType;
import us.timinc.mc.cobblemon.spawnnotification.broadcast.SoundBroadcast;
import us.timinc.mc.cobblemon.timcore.Debugger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\r\u001a\u0006\u0012\u0002\b\u00030\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0017\u0010\u0016R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0018\u001a\u0004\b\u001b\u0010\u001aR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/broadcast/SoundBroadcast;", "Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/Broadcast;", "Lnet/minecraft/resources/ResourceLocation;", "destination", "sound", "", "volume", "pitch", "", "source", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;FFLjava/lang/String;)V", "Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;", "getType", "()Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;", "Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastContext$WithSituations;", "broadcastContext", "", "deliver", "(Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastContext$WithSituations;)V", "Lnet/minecraft/resources/ResourceLocation;", "getDestination", "()Lnet/minecraft/resources/ResourceLocation;", "getSound", "F", "getVolume", "()F", "getPitch", "Ljava/lang/String;", "getSource", "()Ljava/lang/String;", "Companion", "common"})
public final class SoundBroadcast
implements Broadcast {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation destination;
    @NotNull
    private final ResourceLocation sound;
    private final float volume;
    private final float pitch;
    @NotNull
    private final String source;
    @NotNull
    private static final MapCodec<SoundBroadcast> CODEC;
    @NotNull
    private static final BroadcastType<SoundBroadcast> BROADCAST_TYPE;

    public SoundBroadcast(@NotNull ResourceLocation destination, @NotNull ResourceLocation sound, float volume, float pitch, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.destination = destination;
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.source = source;
    }

    @Override
    @NotNull
    public ResourceLocation getDestination() {
        return this.destination;
    }

    @NotNull
    public final ResourceLocation getSound() {
        return this.sound;
    }

    public final float getVolume() {
        return this.volume;
    }

    public final float getPitch() {
        return this.pitch;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public BroadcastType<?> getType() {
        return SpawnNotification.BroadcastTypes.INSTANCE.getSOUND_BROADCAST();
    }

    @Override
    public void deliver(@NotNull BroadcastContext.WithSituations broadcastContext) {
        Intrinsics.checkNotNullParameter((Object)broadcastContext, (String)"broadcastContext");
        SoundEvent soundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)this.sound);
        Level level = (Level)broadcastContext.getWorld();
        Vec3 vec3 = broadcastContext.getPosition();
        Intrinsics.checkNotNull((Object)soundEvent);
        WorldExtensionsKt.playSoundServer((Level)level, (Vec3)vec3, (SoundEvent)soundEvent, (SoundSource)SoundSource.valueOf((String)this.source), (float)this.volume, (float)this.pitch);
        Debugger debugger = SpawnNotification.INSTANCE.getDebugger();
        String string = broadcastContext.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Debugger.Case debugger2 = debugger.getCaseDebugger(string);
        Debugger.debug$default((Debugger)((Debugger)debugger2), (String)("Played sound " + soundEvent), (boolean)false, (int)2, null);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)ResourceLocation.CODEC.fieldOf("destination").forGetter(arg_0 -> SoundBroadcast.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)ResourceLocation.CODEC.fieldOf("sound").forGetter(arg_0 -> SoundBroadcast.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(arg_0 -> SoundBroadcast.CODEC$lambda$0$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0)), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(arg_0 -> SoundBroadcast.CODEC$lambda$0$3((KProperty1)Companion.CODEC.1.4.INSTANCE, arg_0)), (App)Codec.STRING.optionalFieldOf("source", (Object)"NEUTRAL").forGetter(arg_0 -> SoundBroadcast.CODEC$lambda$0$4((KProperty1)Companion.CODEC.1.5.INSTANCE, arg_0))).apply((Applicative)instance, SoundBroadcast::new);
    }

    private static final ResourceLocation CODEC$lambda$0$0(KProperty1 $tmp0, SoundBroadcast p0) {
        return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final ResourceLocation CODEC$lambda$0$1(KProperty1 $tmp0, SoundBroadcast p0) {
        return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Float CODEC$lambda$0$2(KProperty1 $tmp0, SoundBroadcast p0) {
        return (Float)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Float CODEC$lambda$0$3(KProperty1 $tmp0, SoundBroadcast p0) {
        return (Float)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final String CODEC$lambda$0$4(KProperty1 $tmp0, SoundBroadcast p0) {
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(SoundBroadcast::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        BROADCAST_TYPE = new BroadcastType<SoundBroadcast>(CODEC);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/broadcast/SoundBroadcast$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lus/timinc/mc/cobblemon/spawnnotification/broadcast/SoundBroadcast;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;", "BROADCAST_TYPE", "Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;", "getBROADCAST_TYPE", "()Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<SoundBroadcast> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final BroadcastType<SoundBroadcast> getBROADCAST_TYPE() {
            return BROADCAST_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

