/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.pokemon.FossilRevivedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonFaintedEvent;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.api.broadcast.Broadcast;
import us.timinc.mc.cobblemon.spawnnotification.api.broadcast.BroadcastType;
import us.timinc.mc.cobblemon.spawnnotification.api.condition.BroadcastCondition;
import us.timinc.mc.cobblemon.spawnnotification.api.condition.BroadcastConditionType;
import us.timinc.mc.cobblemon.spawnnotification.api.message.Part;
import us.timinc.mc.cobblemon.spawnnotification.api.message.Segment;
import us.timinc.mc.cobblemon.spawnnotification.api.message.SegmentType;
import us.timinc.mc.cobblemon.spawnnotification.broadcast.ChatBroadcast;
import us.timinc.mc.cobblemon.spawnnotification.broadcast.SoundBroadcast;
import us.timinc.mc.cobblemon.spawnnotification.condition.MatcherCondition;
import us.timinc.mc.cobblemon.spawnnotification.config.DisabledSegmentsPerSituations;
import us.timinc.mc.cobblemon.spawnnotification.data.BroadcastDataManager;
import us.timinc.mc.cobblemon.spawnnotification.data.SegmentAdditionDataManager;
import us.timinc.mc.cobblemon.spawnnotification.data.SegmentDataManager;
import us.timinc.mc.cobblemon.spawnnotification.data.SituationDataManager;
import us.timinc.mc.cobblemon.spawnnotification.handler.CaptureTrigger;
import us.timinc.mc.cobblemon.spawnnotification.handler.DespawnTrigger;
import us.timinc.mc.cobblemon.spawnnotification.handler.DieTrigger;
import us.timinc.mc.cobblemon.spawnnotification.handler.FaintTrigger;
import us.timinc.mc.cobblemon.spawnnotification.handler.HatchTrigger;
import us.timinc.mc.cobblemon.spawnnotification.handler.ResurrectTrigger;
import us.timinc.mc.cobblemon.spawnnotification.handler.SpawnTriggers;
import us.timinc.mc.cobblemon.spawnnotification.handler.UnnaturalSpawnTrigger;
import us.timinc.mc.cobblemon.spawnnotification.part.Biome;
import us.timinc.mc.cobblemon.spawnnotification.part.Bucket;
import us.timinc.mc.cobblemon.spawnnotification.part.CoordX;
import us.timinc.mc.cobblemon.spawnnotification.part.CoordY;
import us.timinc.mc.cobblemon.spawnnotification.part.CoordZ;
import us.timinc.mc.cobblemon.spawnnotification.part.DimRawNamespace;
import us.timinc.mc.cobblemon.spawnnotification.part.DimRawPath;
import us.timinc.mc.cobblemon.spawnnotification.part.Dimension;
import us.timinc.mc.cobblemon.spawnnotification.part.PlayerName;
import us.timinc.mc.cobblemon.spawnnotification.part.PokemonForm;
import us.timinc.mc.cobblemon.spawnnotification.part.PokemonSpecies;
import us.timinc.mc.cobblemon.spawnnotification.segment.FullSegment;
import us.timinc.mc.cobblemon.spawnnotification.segment.PartSegment;
import us.timinc.mc.cobblemon.spawnnotification.segment.ReferenceSegment;
import us.timinc.mc.cobblemon.timcore.AbstractConfig;
import us.timinc.mc.cobblemon.timcore.AbstractMod;
import us.timinc.mc.cobblemon.timcore.CustomBooleanProperty;
import us.timinc.mc.cobblemon.timcore.TimCoreEvents;
import us.timinc.mc.cobblemon.timcore.event.EntityDidSpawnEvent;
import us.timinc.mc.cobblemon.timcore.event.EntityLoadEvent;
import us.timinc.mc.cobblemon.timcore.event.EntityUnloadEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\b\u0005\u0006\u0007\b\t\n\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\r"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification;", "Lus/timinc/mc/cobblemon/timcore/AbstractMod;", "Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$SpawnNotificationConfig;", "<init>", "()V", "SpawnNotificationConfig", "KEYS", "CUSTOM_POKEMON_PROPERTIES", "COMPONENTS", "BroadcastTypes", "Parts", "ConditionTypes", "SegmentTypes", "common"})
public final class SpawnNotification
extends AbstractMod<SpawnNotificationConfig> {
    @NotNull
    public static final SpawnNotification INSTANCE = new SpawnNotification();

    private SpawnNotification() {
        super("spawn_notification", SpawnNotificationConfig.class);
    }

    static {
        INSTANCE.registerReloadListener(SegmentDataManager.INSTANCE);
        INSTANCE.registerReloadListener(SituationDataManager.INSTANCE);
        INSTANCE.registerReloadListener(SegmentAdditionDataManager.INSTANCE);
        INSTANCE.registerReloadListener(BroadcastDataManager.INSTANCE);
        TimCoreEvents.POKEMON_ENTITY_DID_SPAWN.subscribe(Priority.NORMAL, (Function1)new Function1<EntityDidSpawnEvent<PokemonEntity>, Unit>((Object)SpawnTriggers.INSTANCE){

            public final void invoke(EntityDidSpawnEvent<PokemonEntity> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((SpawnTriggers)((Object)this.receiver)).handle(p0);
            }
        });
        TimCoreEvents.POKEMON_ENTITY_LOAD.subscribe(Priority.LOWEST, (Function1)new Function1<EntityLoadEvent<PokemonEntity>, Unit>((Object)UnnaturalSpawnTrigger.INSTANCE){

            public final void invoke(EntityLoadEvent<PokemonEntity> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((UnnaturalSpawnTrigger)((Object)this.receiver)).handle(p0);
            }
        });
        TimCoreEvents.POKEMON_ENTITY_UNLOAD.subscribe(Priority.NORMAL, (Function1)new Function1<EntityUnloadEvent<PokemonEntity>, Unit>((Object)DespawnTrigger.INSTANCE){

            public final void invoke(EntityUnloadEvent<PokemonEntity> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((DespawnTrigger)((Object)this.receiver)).handle(p0);
            }
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, (Function1)new Function1<PokemonCapturedEvent, Unit>((Object)CaptureTrigger.INSTANCE){

            public final void invoke(PokemonCapturedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((CaptureTrigger)((Object)this.receiver)).handle(p0);
            }
        });
        CobblemonEvents.POKEMON_FAINTED.subscribe(Priority.NORMAL, (Function1)new Function1<PokemonFaintedEvent, Unit>((Object)DieTrigger.INSTANCE){

            public final void invoke(PokemonFaintedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((DieTrigger)((Object)this.receiver)).handle(p0);
            }
        });
        CobblemonEvents.BATTLE_FAINTED.subscribe(Priority.NORMAL, (Function1)new Function1<BattleFaintedEvent, Unit>((Object)FaintTrigger.INSTANCE){

            public final void invoke(BattleFaintedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((FaintTrigger)((Object)this.receiver)).handle(p0);
            }
        });
        CobblemonEvents.FOSSIL_REVIVED.subscribe(Priority.NORMAL, (Function1)new Function1<FossilRevivedEvent, Unit>((Object)ResurrectTrigger.INSTANCE){

            public final void invoke(FossilRevivedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ResurrectTrigger)((Object)this.receiver)).handle(p0);
            }
        });
        CobblemonEvents.HATCH_EGG_POST.subscribe(Priority.NORMAL, (Function1)new Function1<HatchEggEvent.Post, Unit>((Object)HatchTrigger.INSTANCE){

            public final void invoke(HatchEggEvent.Post p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((HatchTrigger)((Object)this.receiver)).handle(p0);
            }
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\b\"\b\b\u0000\u0010\u0005*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\b8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$BroadcastTypes;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/Broadcast;", "T", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;", "broadcastType", "register", "(Lnet/minecraft/resources/ResourceLocation;Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;)Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;", "Lus/timinc/mc/cobblemon/spawnnotification/broadcast/ChatBroadcast;", "CHAT_BROADCAST", "Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;", "getCHAT_BROADCAST", "()Lus/timinc/mc/cobblemon/spawnnotification/api/broadcast/BroadcastType;", "Lus/timinc/mc/cobblemon/spawnnotification/broadcast/SoundBroadcast;", "SOUND_BROADCAST", "getSOUND_BROADCAST", "common"})
    public static final class BroadcastTypes {
        @NotNull
        public static final BroadcastTypes INSTANCE = new BroadcastTypes();
        @NotNull
        private static final BroadcastType<ChatBroadcast> CHAT_BROADCAST = INSTANCE.register(KEYS.DESTINATIONS.INSTANCE.getCHAT(), ChatBroadcast.Companion.getBROADCAST_TYPE());
        @NotNull
        private static final BroadcastType<SoundBroadcast> SOUND_BROADCAST = INSTANCE.register(KEYS.DESTINATIONS.INSTANCE.getSOUND(), SoundBroadcast.Companion.getBROADCAST_TYPE());

        private BroadcastTypes() {
        }

        @NotNull
        public final BroadcastType<ChatBroadcast> getCHAT_BROADCAST() {
            return CHAT_BROADCAST;
        }

        @NotNull
        public final BroadcastType<SoundBroadcast> getSOUND_BROADCAST() {
            return SOUND_BROADCAST;
        }

        @NotNull
        public final <T extends Broadcast> BroadcastType<T> register(@NotNull ResourceLocation id, @NotNull BroadcastType<T> broadcastType) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(broadcastType, (String)"broadcastType");
            Object object = Registry.register(BroadcastType.Companion.getREGISTRY(), (ResourceLocation)id, broadcastType);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"register(...)");
            return (BroadcastType)object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u001b\u0010\n\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000e\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$COMPONENTS;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/FormData;", "form", "Lnet/minecraft/network/chat/MutableComponent;", "(Lcom/cobblemon/mod/common/pokemon/FormData;)Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "dimension", "(Lnet/minecraft/resources/ResourceKey;)Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "biome", "(Lnet/minecraft/core/Holder;)Lnet/minecraft/network/chat/MutableComponent;", "common"})
    public static final class COMPONENTS {
        @NotNull
        public static final COMPONENTS INSTANCE = new COMPONENTS();

        private COMPONENTS() {
        }

        @NotNull
        public final MutableComponent form(@NotNull FormData form) {
            Intrinsics.checkNotNullParameter((Object)form, (String)"form");
            MutableComponent mutableComponent = Component.translatable((String)("pokemon.form." + form.formOnlyShowdownId()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            return mutableComponent;
        }

        @NotNull
        public final MutableComponent dimension(@NotNull ResourceKey<Level> dimension) {
            Intrinsics.checkNotNullParameter(dimension, (String)"dimension");
            MutableComponent mutableComponent = Component.translatable((String)("dimension." + dimension.location().toLanguageKey()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            return mutableComponent;
        }

        @NotNull
        public final MutableComponent biome(@NotNull Holder<net.minecraft.world.level.biome.Biome> biome) {
            Intrinsics.checkNotNullParameter(biome, (String)"biome");
            MutableComponent mutableComponent = Component.translatable((String)("biome." + ((ResourceKey)biome.unwrapKey().get()).location().toLanguageKey()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            return mutableComponent;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$CUSTOM_POKEMON_PROPERTIES;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/timcore/CustomBooleanProperty;", "BROADCASTED_SPAWN", "Lus/timinc/mc/cobblemon/timcore/CustomBooleanProperty;", "getBROADCASTED_SPAWN", "()Lus/timinc/mc/cobblemon/timcore/CustomBooleanProperty;", "BROADCASTED_DESPAWN", "getBROADCASTED_DESPAWN", "common"})
    public static final class CUSTOM_POKEMON_PROPERTIES {
        @NotNull
        public static final CUSTOM_POKEMON_PROPERTIES INSTANCE = new CUSTOM_POKEMON_PROPERTIES();
        @NotNull
        private static final CustomBooleanProperty BROADCASTED_SPAWN;
        @NotNull
        private static final CustomBooleanProperty BROADCASTED_DESPAWN;

        private CUSTOM_POKEMON_PROPERTIES() {
        }

        @NotNull
        public final CustomBooleanProperty getBROADCASTED_SPAWN() {
            return BROADCASTED_SPAWN;
        }

        @NotNull
        public final CustomBooleanProperty getBROADCASTED_DESPAWN() {
            return BROADCASTED_DESPAWN;
        }

        static {
            String string = KEYS.POKEMON_PROPERTIES.INSTANCE.getSPAWN_BROADCASTED().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            BROADCASTED_SPAWN = new CustomBooleanProperty(string);
            String string2 = KEYS.POKEMON_PROPERTIES.INSTANCE.getDESPAWN_BROADCASTED().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            BROADCASTED_DESPAWN = new CustomBooleanProperty(string2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\b\"\b\b\u0000\u0010\u0005*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$ConditionTypes;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/spawnnotification/api/condition/BroadcastCondition;", "T", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lus/timinc/mc/cobblemon/spawnnotification/api/condition/BroadcastConditionType;", "broadcastConditionType", "register", "(Lnet/minecraft/resources/ResourceLocation;Lus/timinc/mc/cobblemon/spawnnotification/api/condition/BroadcastConditionType;)Lus/timinc/mc/cobblemon/spawnnotification/api/condition/BroadcastConditionType;", "Lus/timinc/mc/cobblemon/spawnnotification/condition/MatcherCondition;", "MATCHER", "Lus/timinc/mc/cobblemon/spawnnotification/api/condition/BroadcastConditionType;", "getMATCHER", "()Lus/timinc/mc/cobblemon/spawnnotification/api/condition/BroadcastConditionType;", "common"})
    public static final class ConditionTypes {
        @NotNull
        public static final ConditionTypes INSTANCE = new ConditionTypes();
        @NotNull
        private static final BroadcastConditionType<MatcherCondition> MATCHER = INSTANCE.register(KEYS.CONDITIONS.INSTANCE.getMATCHER(), MatcherCondition.Companion.getCONDITION_TYPE());

        private ConditionTypes() {
        }

        @NotNull
        public final BroadcastConditionType<MatcherCondition> getMATCHER() {
            return MATCHER;
        }

        @NotNull
        public final <T extends BroadcastCondition> BroadcastConditionType<T> register(@NotNull ResourceLocation id, @NotNull BroadcastConditionType<T> broadcastConditionType) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(broadcastConditionType, (String)"broadcastConditionType");
            Object object = Registry.register(BroadcastConditionType.Companion.getREGISTRY(), (ResourceLocation)id, broadcastConditionType);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"register(...)");
            return (BroadcastConditionType)object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u0004\u0005\u0006\u0007\b\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$KEYS;", "", "<init>", "()V", "TRIGGERS", "DESTINATIONS", "PARTS", "CONDITIONS", "SEGMENTS", "POKEMON_PROPERTIES", "common"})
    public static final class KEYS {
        @NotNull
        public static final KEYS INSTANCE = new KEYS();

        private KEYS() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$KEYS$CONDITIONS;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "MATCHER", "Lnet/minecraft/resources/ResourceLocation;", "getMATCHER", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
        public static final class CONDITIONS {
            @NotNull
            public static final CONDITIONS INSTANCE = new CONDITIONS();
            @NotNull
            private static final ResourceLocation MATCHER = SpawnNotification.INSTANCE.modResource("matcher");

            private CONDITIONS() {
            }

            @NotNull
            public final ResourceLocation getMATCHER() {
                return MATCHER;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$KEYS$DESTINATIONS;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "CHAT", "Lnet/minecraft/resources/ResourceLocation;", "getCHAT", "()Lnet/minecraft/resources/ResourceLocation;", "SOUND", "getSOUND", "common"})
        public static final class DESTINATIONS {
            @NotNull
            public static final DESTINATIONS INSTANCE = new DESTINATIONS();
            @NotNull
            private static final ResourceLocation CHAT = SpawnNotification.INSTANCE.modResource("chat");
            @NotNull
            private static final ResourceLocation SOUND = SpawnNotification.INSTANCE.modResource("sound");

            private DESTINATIONS() {
            }

            @NotNull
            public final ResourceLocation getCHAT() {
                return CHAT;
            }

            @NotNull
            public final ResourceLocation getSOUND() {
                return SOUND;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0006\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0006\u001a\u0004\b\u0010\u0010\bR\u0017\u0010\u0011\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0006\u001a\u0004\b\u0012\u0010\bR\u0017\u0010\u0013\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0006\u001a\u0004\b\u0014\u0010\bR\u0017\u0010\u0015\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0006\u001a\u0004\b\u0016\u0010\bR\u0017\u0010\u0017\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0006\u001a\u0004\b\u0018\u0010\bR\u0017\u0010\u0019\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0006\u001a\u0004\b\u001a\u0010\bR\u0017\u0010\u001b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0006\u001a\u0004\b\u001c\u0010\b\u00a8\u0006\u001d"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$KEYS$PARTS;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "POKEMON_SPECIES", "Lnet/minecraft/resources/ResourceLocation;", "getPOKEMON_SPECIES", "()Lnet/minecraft/resources/ResourceLocation;", "POKEMON_FORM", "getPOKEMON_FORM", "PLAYER_NAME", "getPLAYER_NAME", "BIOME", "getBIOME", "DIMENSION", "getDIMENSION", "BUCKET", "getBUCKET", "COORD_X", "getCOORD_X", "COORD_Y", "getCOORD_Y", "COORD_Z", "getCOORD_Z", "DIM_RAW_PATH", "getDIM_RAW_PATH", "DIM_RAW_NAMESPACE", "getDIM_RAW_NAMESPACE", "common"})
        public static final class PARTS {
            @NotNull
            public static final PARTS INSTANCE = new PARTS();
            @NotNull
            private static final ResourceLocation POKEMON_SPECIES = SpawnNotification.INSTANCE.modResource("pokemon_species");
            @NotNull
            private static final ResourceLocation POKEMON_FORM = SpawnNotification.INSTANCE.modResource("pokemon_form");
            @NotNull
            private static final ResourceLocation PLAYER_NAME = SpawnNotification.INSTANCE.modResource("player_name");
            @NotNull
            private static final ResourceLocation BIOME = SpawnNotification.INSTANCE.modResource("biome");
            @NotNull
            private static final ResourceLocation DIMENSION = SpawnNotification.INSTANCE.modResource("dimension");
            @NotNull
            private static final ResourceLocation BUCKET = SpawnNotification.INSTANCE.modResource("bucket");
            @NotNull
            private static final ResourceLocation COORD_X = SpawnNotification.INSTANCE.modResource("coord_x");
            @NotNull
            private static final ResourceLocation COORD_Y = SpawnNotification.INSTANCE.modResource("coord_y");
            @NotNull
            private static final ResourceLocation COORD_Z = SpawnNotification.INSTANCE.modResource("coord_z");
            @NotNull
            private static final ResourceLocation DIM_RAW_PATH = SpawnNotification.INSTANCE.modResource("dim_raw_path");
            @NotNull
            private static final ResourceLocation DIM_RAW_NAMESPACE = SpawnNotification.INSTANCE.modResource("dim_raw_namespace");

            private PARTS() {
            }

            @NotNull
            public final ResourceLocation getPOKEMON_SPECIES() {
                return POKEMON_SPECIES;
            }

            @NotNull
            public final ResourceLocation getPOKEMON_FORM() {
                return POKEMON_FORM;
            }

            @NotNull
            public final ResourceLocation getPLAYER_NAME() {
                return PLAYER_NAME;
            }

            @NotNull
            public final ResourceLocation getBIOME() {
                return BIOME;
            }

            @NotNull
            public final ResourceLocation getDIMENSION() {
                return DIMENSION;
            }

            @NotNull
            public final ResourceLocation getBUCKET() {
                return BUCKET;
            }

            @NotNull
            public final ResourceLocation getCOORD_X() {
                return COORD_X;
            }

            @NotNull
            public final ResourceLocation getCOORD_Y() {
                return COORD_Y;
            }

            @NotNull
            public final ResourceLocation getCOORD_Z() {
                return COORD_Z;
            }

            @NotNull
            public final ResourceLocation getDIM_RAW_PATH() {
                return DIM_RAW_PATH;
            }

            @NotNull
            public final ResourceLocation getDIM_RAW_NAMESPACE() {
                return DIM_RAW_NAMESPACE;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$KEYS$POKEMON_PROPERTIES;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "SPAWN_BROADCASTED", "Lnet/minecraft/resources/ResourceLocation;", "getSPAWN_BROADCASTED", "()Lnet/minecraft/resources/ResourceLocation;", "DESPAWN_BROADCASTED", "getDESPAWN_BROADCASTED", "common"})
        public static final class POKEMON_PROPERTIES {
            @NotNull
            public static final POKEMON_PROPERTIES INSTANCE = new POKEMON_PROPERTIES();
            @NotNull
            private static final ResourceLocation SPAWN_BROADCASTED = SpawnNotification.INSTANCE.modResource("spawn_broadcasted");
            @NotNull
            private static final ResourceLocation DESPAWN_BROADCASTED = SpawnNotification.INSTANCE.modResource("despawn_broadcasted");

            private POKEMON_PROPERTIES() {
            }

            @NotNull
            public final ResourceLocation getSPAWN_BROADCASTED() {
                return SPAWN_BROADCASTED;
            }

            @NotNull
            public final ResourceLocation getDESPAWN_BROADCASTED() {
                return DESPAWN_BROADCASTED;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\r"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$KEYS$SEGMENTS;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "REFERENCE", "Lnet/minecraft/resources/ResourceLocation;", "getREFERENCE", "()Lnet/minecraft/resources/ResourceLocation;", "PART", "getPART", "FULL", "getFULL", "common"})
        public static final class SEGMENTS {
            @NotNull
            public static final SEGMENTS INSTANCE = new SEGMENTS();
            @NotNull
            private static final ResourceLocation REFERENCE = SpawnNotification.INSTANCE.modResource("reference");
            @NotNull
            private static final ResourceLocation PART = SpawnNotification.INSTANCE.modResource("part");
            @NotNull
            private static final ResourceLocation FULL = SpawnNotification.INSTANCE.modResource("full");

            private SEGMENTS() {
            }

            @NotNull
            public final ResourceLocation getREFERENCE() {
                return REFERENCE;
            }

            @NotNull
            public final ResourceLocation getPART() {
                return PART;
            }

            @NotNull
            public final ResourceLocation getFULL() {
                return FULL;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0006\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0006\u001a\u0004\b\u0010\u0010\bR\u0017\u0010\u0011\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0006\u001a\u0004\b\u0012\u0010\bR\u0017\u0010\u0013\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0006\u001a\u0004\b\u0014\u0010\bR\u0017\u0010\u0015\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0006\u001a\u0004\b\u0016\u0010\bR\u0017\u0010\u0017\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0006\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u0019"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$KEYS$TRIGGERS;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "SPAWNED", "Lnet/minecraft/resources/ResourceLocation;", "getSPAWNED", "()Lnet/minecraft/resources/ResourceLocation;", "FISHED", "getFISHED", "SNACKED", "getSNACKED", "CAPTURED", "getCAPTURED", "FAINTED", "getFAINTED", "DIED", "getDIED", "DESPAWNED", "getDESPAWNED", "RESURRECTED", "getRESURRECTED", "HATCHED", "getHATCHED", "common"})
        public static final class TRIGGERS {
            @NotNull
            public static final TRIGGERS INSTANCE = new TRIGGERS();
            @NotNull
            private static final ResourceLocation SPAWNED = SpawnNotification.INSTANCE.modResource("spawned");
            @NotNull
            private static final ResourceLocation FISHED = SpawnNotification.INSTANCE.modResource("fished");
            @NotNull
            private static final ResourceLocation SNACKED = SpawnNotification.INSTANCE.modResource("snacked");
            @NotNull
            private static final ResourceLocation CAPTURED = SpawnNotification.INSTANCE.modResource("captured");
            @NotNull
            private static final ResourceLocation FAINTED = SpawnNotification.INSTANCE.modResource("fainted");
            @NotNull
            private static final ResourceLocation DIED = SpawnNotification.INSTANCE.modResource("died");
            @NotNull
            private static final ResourceLocation DESPAWNED = SpawnNotification.INSTANCE.modResource("despawned");
            @NotNull
            private static final ResourceLocation RESURRECTED = SpawnNotification.INSTANCE.modResource("resurrected");
            @NotNull
            private static final ResourceLocation HATCHED = SpawnNotification.INSTANCE.modResource("hatched");

            private TRIGGERS() {
            }

            @NotNull
            public final ResourceLocation getSPAWNED() {
                return SPAWNED;
            }

            @NotNull
            public final ResourceLocation getFISHED() {
                return FISHED;
            }

            @NotNull
            public final ResourceLocation getSNACKED() {
                return SNACKED;
            }

            @NotNull
            public final ResourceLocation getCAPTURED() {
                return CAPTURED;
            }

            @NotNull
            public final ResourceLocation getFAINTED() {
                return FAINTED;
            }

            @NotNull
            public final ResourceLocation getDIED() {
                return DIED;
            }

            @NotNull
            public final ResourceLocation getDESPAWNED() {
                return DESPAWNED;
            }

            @NotNull
            public final ResourceLocation getRESURRECTED() {
                return RESURRECTED;
            }

            @NotNull
            public final ResourceLocation getHATCHED() {
                return HATCHED;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\u00028\u0000\"\b\b\u0000\u0010\u0005*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010%\u001a\u00020$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010*\u001a\u00020)8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010/\u001a\u00020.8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0017\u00104\u001a\u0002038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\u0017\u00109\u001a\u0002088\u0006\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<R\u0017\u0010>\u001a\u00020=8\u0006\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b@\u0010A\u00a8\u0006B"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$Parts;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/spawnnotification/api/message/Part;", "T", "Lnet/minecraft/resources/ResourceLocation;", "id", "part", "register", "(Lnet/minecraft/resources/ResourceLocation;Lus/timinc/mc/cobblemon/spawnnotification/api/message/Part;)Lus/timinc/mc/cobblemon/spawnnotification/api/message/Part;", "Lus/timinc/mc/cobblemon/spawnnotification/part/Biome;", "BIOME", "Lus/timinc/mc/cobblemon/spawnnotification/part/Biome;", "getBIOME", "()Lus/timinc/mc/cobblemon/spawnnotification/part/Biome;", "Lus/timinc/mc/cobblemon/spawnnotification/part/Bucket;", "BUCKET", "Lus/timinc/mc/cobblemon/spawnnotification/part/Bucket;", "getBUCKET", "()Lus/timinc/mc/cobblemon/spawnnotification/part/Bucket;", "Lus/timinc/mc/cobblemon/spawnnotification/part/Dimension;", "DIMENSION", "Lus/timinc/mc/cobblemon/spawnnotification/part/Dimension;", "getDIMENSION", "()Lus/timinc/mc/cobblemon/spawnnotification/part/Dimension;", "Lus/timinc/mc/cobblemon/spawnnotification/part/PlayerName;", "PLAYER_NAME", "Lus/timinc/mc/cobblemon/spawnnotification/part/PlayerName;", "getPLAYER_NAME", "()Lus/timinc/mc/cobblemon/spawnnotification/part/PlayerName;", "Lus/timinc/mc/cobblemon/spawnnotification/part/PokemonForm;", "POKEMON_FORM", "Lus/timinc/mc/cobblemon/spawnnotification/part/PokemonForm;", "getPOKEMON_FORM", "()Lus/timinc/mc/cobblemon/spawnnotification/part/PokemonForm;", "Lus/timinc/mc/cobblemon/spawnnotification/part/PokemonSpecies;", "POKEMON_SPECIES", "Lus/timinc/mc/cobblemon/spawnnotification/part/PokemonSpecies;", "getPOKEMON_SPECIES", "()Lus/timinc/mc/cobblemon/spawnnotification/part/PokemonSpecies;", "Lus/timinc/mc/cobblemon/spawnnotification/part/CoordX;", "COORD_X", "Lus/timinc/mc/cobblemon/spawnnotification/part/CoordX;", "getCOORD_X", "()Lus/timinc/mc/cobblemon/spawnnotification/part/CoordX;", "Lus/timinc/mc/cobblemon/spawnnotification/part/CoordY;", "COORD_Y", "Lus/timinc/mc/cobblemon/spawnnotification/part/CoordY;", "getCOORD_Y", "()Lus/timinc/mc/cobblemon/spawnnotification/part/CoordY;", "Lus/timinc/mc/cobblemon/spawnnotification/part/CoordZ;", "COORD_Z", "Lus/timinc/mc/cobblemon/spawnnotification/part/CoordZ;", "getCOORD_Z", "()Lus/timinc/mc/cobblemon/spawnnotification/part/CoordZ;", "Lus/timinc/mc/cobblemon/spawnnotification/part/DimRawPath;", "DIM_RAW_PATH", "Lus/timinc/mc/cobblemon/spawnnotification/part/DimRawPath;", "getDIM_RAW_PATH", "()Lus/timinc/mc/cobblemon/spawnnotification/part/DimRawPath;", "Lus/timinc/mc/cobblemon/spawnnotification/part/DimRawNamespace;", "DIM_RAW_NAMESPACE", "Lus/timinc/mc/cobblemon/spawnnotification/part/DimRawNamespace;", "getDIM_RAW_NAMESPACE", "()Lus/timinc/mc/cobblemon/spawnnotification/part/DimRawNamespace;", "common"})
    public static final class Parts {
        @NotNull
        public static final Parts INSTANCE = new Parts();
        @NotNull
        private static final Biome BIOME = (Biome)INSTANCE.register(KEYS.PARTS.INSTANCE.getBIOME(), (Part)Biome.INSTANCE);
        @NotNull
        private static final Bucket BUCKET = (Bucket)INSTANCE.register(KEYS.PARTS.INSTANCE.getBUCKET(), (Part)Bucket.INSTANCE);
        @NotNull
        private static final Dimension DIMENSION = (Dimension)INSTANCE.register(KEYS.PARTS.INSTANCE.getDIMENSION(), (Part)Dimension.INSTANCE);
        @NotNull
        private static final PlayerName PLAYER_NAME = (PlayerName)INSTANCE.register(KEYS.PARTS.INSTANCE.getPLAYER_NAME(), (Part)PlayerName.INSTANCE);
        @NotNull
        private static final PokemonForm POKEMON_FORM = (PokemonForm)INSTANCE.register(KEYS.PARTS.INSTANCE.getPOKEMON_FORM(), (Part)PokemonForm.INSTANCE);
        @NotNull
        private static final PokemonSpecies POKEMON_SPECIES = (PokemonSpecies)INSTANCE.register(KEYS.PARTS.INSTANCE.getPOKEMON_SPECIES(), (Part)PokemonSpecies.INSTANCE);
        @NotNull
        private static final CoordX COORD_X = (CoordX)INSTANCE.register(KEYS.PARTS.INSTANCE.getCOORD_X(), (Part)CoordX.INSTANCE);
        @NotNull
        private static final CoordY COORD_Y = (CoordY)INSTANCE.register(KEYS.PARTS.INSTANCE.getCOORD_Y(), (Part)CoordY.INSTANCE);
        @NotNull
        private static final CoordZ COORD_Z = (CoordZ)INSTANCE.register(KEYS.PARTS.INSTANCE.getCOORD_Z(), (Part)CoordZ.INSTANCE);
        @NotNull
        private static final DimRawPath DIM_RAW_PATH = (DimRawPath)INSTANCE.register(KEYS.PARTS.INSTANCE.getDIM_RAW_PATH(), (Part)DimRawPath.INSTANCE);
        @NotNull
        private static final DimRawNamespace DIM_RAW_NAMESPACE = (DimRawNamespace)INSTANCE.register(KEYS.PARTS.INSTANCE.getDIM_RAW_NAMESPACE(), (Part)DimRawNamespace.INSTANCE);

        private Parts() {
        }

        @NotNull
        public final Biome getBIOME() {
            return BIOME;
        }

        @NotNull
        public final Bucket getBUCKET() {
            return BUCKET;
        }

        @NotNull
        public final Dimension getDIMENSION() {
            return DIMENSION;
        }

        @NotNull
        public final PlayerName getPLAYER_NAME() {
            return PLAYER_NAME;
        }

        @NotNull
        public final PokemonForm getPOKEMON_FORM() {
            return POKEMON_FORM;
        }

        @NotNull
        public final PokemonSpecies getPOKEMON_SPECIES() {
            return POKEMON_SPECIES;
        }

        @NotNull
        public final CoordX getCOORD_X() {
            return COORD_X;
        }

        @NotNull
        public final CoordY getCOORD_Y() {
            return COORD_Y;
        }

        @NotNull
        public final CoordZ getCOORD_Z() {
            return COORD_Z;
        }

        @NotNull
        public final DimRawPath getDIM_RAW_PATH() {
            return DIM_RAW_PATH;
        }

        @NotNull
        public final DimRawNamespace getDIM_RAW_NAMESPACE() {
            return DIM_RAW_NAMESPACE;
        }

        @NotNull
        public final <T extends Part> T register(@NotNull ResourceLocation id, @NotNull T part) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(part, (String)"part");
            Object object = Registry.register(Part.Companion.getREGISTRY(), (ResourceLocation)id, part);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"register(...)");
            return (T)((Part)object);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\b\"\b\b\u0000\u0010\u0005*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\b8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0013\u0010\u0010R\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\b8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$SegmentTypes;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/spawnnotification/api/message/Segment;", "T", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lus/timinc/mc/cobblemon/spawnnotification/api/message/SegmentType;", "segmentType", "register", "(Lnet/minecraft/resources/ResourceLocation;Lus/timinc/mc/cobblemon/spawnnotification/api/message/SegmentType;)Lus/timinc/mc/cobblemon/spawnnotification/api/message/SegmentType;", "Lus/timinc/mc/cobblemon/spawnnotification/segment/ReferenceSegment;", "REFERENCE", "Lus/timinc/mc/cobblemon/spawnnotification/api/message/SegmentType;", "getREFERENCE", "()Lus/timinc/mc/cobblemon/spawnnotification/api/message/SegmentType;", "Lus/timinc/mc/cobblemon/spawnnotification/segment/PartSegment;", "PART", "getPART", "Lus/timinc/mc/cobblemon/spawnnotification/segment/FullSegment;", "FULL", "getFULL", "common"})
    public static final class SegmentTypes {
        @NotNull
        public static final SegmentTypes INSTANCE = new SegmentTypes();
        @NotNull
        private static final SegmentType<ReferenceSegment> REFERENCE = INSTANCE.register(KEYS.SEGMENTS.INSTANCE.getREFERENCE(), ReferenceSegment.Companion.getSEGMENT_TYPE());
        @NotNull
        private static final SegmentType<PartSegment> PART = INSTANCE.register(KEYS.SEGMENTS.INSTANCE.getPART(), PartSegment.Companion.getSEGMENT_TYPE());
        @NotNull
        private static final SegmentType<FullSegment> FULL = INSTANCE.register(KEYS.SEGMENTS.INSTANCE.getFULL(), FullSegment.Companion.getSEGMENT_TYPE());

        private SegmentTypes() {
        }

        @NotNull
        public final SegmentType<ReferenceSegment> getREFERENCE() {
            return REFERENCE;
        }

        @NotNull
        public final SegmentType<PartSegment> getPART() {
            return PART;
        }

        @NotNull
        public final SegmentType<FullSegment> getFULL() {
            return FULL;
        }

        @NotNull
        public final <T extends Segment> SegmentType<T> register(@NotNull ResourceLocation id, @NotNull SegmentType<T> segmentType) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(segmentType, (String)"segmentType");
            Object object = Registry.register(SegmentType.Companion.getREGISTRY(), (ResourceLocation)id, segmentType);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"register(...)");
            return (SegmentType)object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\f\u001a\u00020\u000b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R#\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u001e\u001a\u0004\b\"\u0010 R\u001d\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/SpawnNotification$SpawnNotificationConfig;", "Lus/timinc/mc/cobblemon/timcore/AbstractConfig;", "<init>", "()V", "", "broadcastRange", "I", "getBroadcastRange", "()I", "playerLimit", "getPlayerLimit", "", "broadcastAcrossDimensions", "Z", "getBroadcastAcrossDimensions", "()Z", "actionBar", "getActionBar", "", "baseColor", "Ljava/lang/String;", "getBaseColor", "()Ljava/lang/String;", "", "partColors", "Ljava/util/Map;", "getPartColors", "()Ljava/util/Map;", "", "disabledSituations", "Ljava/util/Set;", "getDisabledSituations", "()Ljava/util/Set;", "disabledSegments", "getDisabledSegments", "", "Lus/timinc/mc/cobblemon/spawnnotification/config/DisabledSegmentsPerSituations;", "disabledSegmentsBySituation", "Ljava/util/List;", "getDisabledSegmentsBySituation", "()Ljava/util/List;", "common"})
    public static final class SpawnNotificationConfig
    extends AbstractConfig {
        private final int broadcastRange;
        private final int playerLimit;
        private final boolean broadcastAcrossDimensions;
        private final boolean actionBar;
        @NotNull
        private final String baseColor;
        @NotNull
        private final Map<String, String> partColors;
        @NotNull
        private final Set<String> disabledSituations;
        @NotNull
        private final Set<String> disabledSegments;
        @NotNull
        private final List<DisabledSegmentsPerSituations> disabledSegmentsBySituation;

        public SpawnNotificationConfig() {
            this.broadcastRange = -1;
            this.playerLimit = -1;
            this.baseColor = "GRAY";
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)"spawn_notification:pokemon_species", (Object)"WHITE"), TuplesKt.to((Object)"spawn_notification:pokemon_form", (Object)"WHITE"), TuplesKt.to((Object)"spawn_notification:player_name", (Object)"WHITE"), TuplesKt.to((Object)"spawn_notification:biome", (Object)"WHITE"), TuplesKt.to((Object)"spawn_notification:dimension", (Object)"WHITE"), TuplesKt.to((Object)"spawn_notification:bucket", (Object)"WHITE"), TuplesKt.to((Object)"spawn_notification:coord_x", (Object)"WHITE"), TuplesKt.to((Object)"spawn_notification:coord_y", (Object)"WHITE"), TuplesKt.to((Object)"spawn_notification:coord_z", (Object)"WHITE")};
            this.partColors = MapsKt.mapOf((Pair[])objectArray);
            this.disabledSituations = SetsKt.emptySet();
            this.disabledSegments = SetsKt.emptySet();
            objectArray = new DisabledSegmentsPerSituations[2];
            Object[] objectArray2 = new String[]{"spawn_notification:*/captured", "spawn_notification:*/fished", "spawn_notification:*/resurrected", "spawn_notification:*/hatched"};
            List list = CollectionsKt.listOf((Object[])objectArray2);
            objectArray2 = new String[]{"spawn_notification:coordinates", "spawn_notification:biome", "spawn_notification:dimension"};
            objectArray[0] = new DisabledSegmentsPerSituations(list, CollectionsKt.listOf((Object[])objectArray2));
            objectArray2 = new String[]{"spawn_notification:*/despawned", "spawn_notification:*/snacked", "spawn_notification:*/spawned"};
            objectArray[1] = new DisabledSegmentsPerSituations(CollectionsKt.listOf((Object[])objectArray2), CollectionsKt.listOf((Object)"spawn_notification:player"));
            this.disabledSegmentsBySituation = CollectionsKt.listOf((Object[])objectArray);
        }

        public final int getBroadcastRange() {
            return this.broadcastRange;
        }

        public final int getPlayerLimit() {
            return this.playerLimit;
        }

        public final boolean getBroadcastAcrossDimensions() {
            return this.broadcastAcrossDimensions;
        }

        public final boolean getActionBar() {
            return this.actionBar;
        }

        @NotNull
        public final String getBaseColor() {
            return this.baseColor;
        }

        @NotNull
        public final Map<String, String> getPartColors() {
            return this.partColors;
        }

        @NotNull
        public final Set<String> getDisabledSituations() {
            return this.disabledSituations;
        }

        @NotNull
        public final Set<String> getDisabledSegments() {
            return this.disabledSegments;
        }

        @NotNull
        public final List<DisabledSegmentsPerSituations> getDisabledSegmentsBySituation() {
            return this.disabledSegmentsBySituation;
        }
    }
}

