/*
 * Decompiled with CFR 0.152.
 */
package com.nbp.neoforge.compat.curios;

import com.nbp.cobblemon_smartphone.CobblemonSmartphone;
import com.nbp.cobblemon_smartphone.item.SmartphoneItem;
import com.nbp.cobblemon_smartphone.registry.CobblemonSmartphoneItems;
import com.nbp.neoforge.compat.curios.SmartphoneCurio;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0003R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/nbp/neoforge/compat/curios/CuriosCompat;", "", "<init>", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/item/ItemStack;", "getEquippedSmartphone", "(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/item/ItemStack;", "", "hasSmartphoneEquipped", "(Lnet/minecraft/world/entity/player/Player;)Z", "", "register", "Lcom/nbp/neoforge/compat/curios/SmartphoneCurio;", "smartphoneCurio", "Lcom/nbp/neoforge/compat/curios/SmartphoneCurio;", "cobblemon_smartphone-neoforge"})
@SourceDebugExtension(value={"SMAP\nCuriosCompat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CuriosCompat.kt\ncom/nbp/neoforge/compat/curios/CuriosCompat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1869#2,2:81\n*S KotlinDebug\n*F\n+ 1 CuriosCompat.kt\ncom/nbp/neoforge/compat/curios/CuriosCompat\n*L\n73#1:81,2\n*E\n"})
public final class CuriosCompat {
    @NotNull
    public static final CuriosCompat INSTANCE = new CuriosCompat();
    @NotNull
    private static final SmartphoneCurio smartphoneCurio = new SmartphoneCurio();

    private CuriosCompat() {
    }

    @Nullable
    public final ItemStack getEquippedSmartphone(@NotNull Player player) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        try {
            Optional curiosOpt = CuriosApi.getCuriosInventory((LivingEntity)((LivingEntity)player));
            if (curiosOpt.isPresent()) {
                Object t = curiosOpt.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                ICuriosItemHandler curios = (ICuriosItemHandler)t;
                Optional smartphoneSlot = curios.findFirstCurio(CuriosCompat::getEquippedSmartphone$lambda$0);
                if (smartphoneSlot.isPresent()) {
                    return ((SlotResult)smartphoneSlot.get()).stack();
                }
            }
            itemStack = null;
        }
        catch (Exception e) {
            CobblemonSmartphone.INSTANCE.getLOGGER().debug("Error getting smartphone from Curios: " + e.getMessage());
            itemStack = null;
        }
        return itemStack;
    }

    public final boolean hasSmartphoneEquipped(@NotNull Player player) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        try {
            boolean bl2;
            Optional curiosOpt = CuriosApi.getCuriosInventory((LivingEntity)((LivingEntity)player));
            if (curiosOpt.isPresent()) {
                Object t = curiosOpt.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                ICuriosItemHandler curios = (ICuriosItemHandler)t;
                bl2 = curios.findFirstCurio(CuriosCompat::hasSmartphoneEquipped$lambda$1).isPresent();
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            CobblemonSmartphone.INSTANCE.getLOGGER().debug("Error checking Curios: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    public final void register() {
        Iterable $this$forEach$iv = CobblemonSmartphoneItems.INSTANCE.all();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Item item = (Item)element$iv;
            boolean bl = false;
            CuriosApi.registerCurio((Item)item, (ICurioItem)smartphoneCurio);
        }
        CobblemonSmartphone.INSTANCE.getLOGGER().info("Curios integration enabled - registered " + CobblemonSmartphoneItems.INSTANCE.all().size() + " smartphones");
    }

    private static final boolean getEquippedSmartphone$lambda$0(ItemStack stack) {
        return stack.getItem() instanceof SmartphoneItem;
    }

    private static final boolean hasSmartphoneEquipped$lambda$1(ItemStack stack) {
        return stack.getItem() instanceof SmartphoneItem;
    }
}

