/*
 * Decompiled with CFR 0.152.
 */
package com.nbp.neoforge.compat;

import com.nbp.cobblemon_smartphone.CobblemonSmartphone;
import com.nbp.cobblemon_smartphone.item.SmartphoneItem;
import com.nbp.neoforge.compat.curios.CuriosCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/nbp/neoforge/compat/SmartphoneCompatManager;", "", "<init>", "()V", "", "init", "", "isCuriosLoaded", "()Z", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/item/ItemStack;", "getSmartphoneFromCurios", "(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/item/ItemStack;", "getSmartphone", "Lcom/nbp/cobblemon_smartphone/item/SmartphoneItem;", "getSmartphoneItem", "(Lnet/minecraft/world/entity/player/Player;)Lcom/nbp/cobblemon_smartphone/item/SmartphoneItem;", "curiosLoaded", "Z", "cobblemon_smartphone-neoforge"})
@SourceDebugExtension(value={"SMAP\nSmartphoneCompatManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartphoneCompatManager.kt\ncom/nbp/neoforge/compat/SmartphoneCompatManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n295#2,2:84\n*S KotlinDebug\n*F\n+ 1 SmartphoneCompatManager.kt\ncom/nbp/neoforge/compat/SmartphoneCompatManager\n*L\n71#1:84,2\n*E\n"})
public final class SmartphoneCompatManager {
    @NotNull
    public static final SmartphoneCompatManager INSTANCE = new SmartphoneCompatManager();
    private static boolean curiosLoaded;

    private SmartphoneCompatManager() {
    }

    public final void init() {
        curiosLoaded = ModList.get().isLoaded("curios");
        if (curiosLoaded) {
            try {
                CuriosCompat.INSTANCE.register();
                CobblemonSmartphone.INSTANCE.getLOGGER().info("Curios compatibility initialized successfully");
            }
            catch (Exception e) {
                CobblemonSmartphone.INSTANCE.getLOGGER().error("Failed to initialize Curios compatibility", (Throwable)e);
                curiosLoaded = false;
            }
        }
    }

    public final boolean isCuriosLoaded() {
        return curiosLoaded;
    }

    @Nullable
    public final ItemStack getSmartphoneFromCurios(@NotNull Player player) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!curiosLoaded) {
            return null;
        }
        try {
            itemStack = CuriosCompat.INSTANCE.getEquippedSmartphone(player);
        }
        catch (Exception e) {
            CobblemonSmartphone.INSTANCE.getLOGGER().error("Error checking Curios slots", (Throwable)e);
            itemStack = null;
        }
        return itemStack;
    }

    @Nullable
    public final ItemStack getSmartphone(@NotNull Player player) {
        Object v1;
        block2: {
            ItemStack curiosSmartphone;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (curiosLoaded && (curiosSmartphone = this.getSmartphoneFromCurios(player)) != null) {
                return curiosSmartphone;
            }
            NonNullList nonNullList = player.getInventory().items;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
            Iterable $this$firstOrNull$iv = (Iterable)nonNullList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                if (!(it.getItem() instanceof SmartphoneItem)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final SmartphoneItem getSmartphoneItem(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = this.getSmartphone(player);
        Item item = itemStack != null ? itemStack.getItem() : null;
        return item instanceof SmartphoneItem ? (SmartphoneItem)item : null;
    }
}

