/*
 * Decompiled with CFR 0.152.
 */
package com.nbp.cobblemon_smartphone.network.handler;

import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.nbp.cobblemon_smartphone.CobblemonSmartphone;
import com.nbp.cobblemon_smartphone.network.handler.HealPokemonCooldowns;
import com.nbp.cobblemon_smartphone.network.packet.HealPokemonPacket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/nbp/cobblemon_smartphone/network/handler/HealPokemonHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/nbp/cobblemon_smartphone/network/packet/HealPokemonPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "handle", "(Lcom/nbp/cobblemon_smartphone/network/packet/HealPokemonPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerPlayer;)V", "cobblemon_smartphone-common"})
public final class HealPokemonHandler
implements ServerNetworkPacketHandler<HealPokemonPacket> {
    @NotNull
    public static final HealPokemonHandler INSTANCE = new HealPokemonHandler();

    private HealPokemonHandler() {
    }

    public void handle(@NotNull HealPokemonPacket packet, @NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        server.execute(() -> HealPokemonHandler.handle$lambda$0(player));
    }

    private static final void handle$lambda$0(ServerPlayer $player) {
        int cooldown;
        boolean isEnabled = CobblemonSmartphone.INSTANCE.getConfig().getFeatures().getEnableHeal();
        if (!isEnabled) {
            $player.displayClientMessage((Component)Component.translatable((String)"message.nbp.heal.disabled").withColor(16580864), true);
            return;
        }
        long currentTime = System.currentTimeMillis() / (long)1000;
        Long l = HealPokemonCooldowns.INSTANCE.getLastHealUse().get($player.getUUID());
        long lastUse = l != null ? l : 0L;
        long timeElapsed = currentTime - lastUse;
        if (timeElapsed < (long)(cooldown = CobblemonSmartphone.INSTANCE.getConfig().getCooldowns().getHealButton())) {
            int remainingSeconds = (int)((long)cooldown - timeElapsed);
            Object[] objectArray = new Object[]{remainingSeconds};
            $player.displayClientMessage((Component)Component.translatable((String)"message.nbp.heal.cooldown", (Object[])objectArray).withColor(16580864), true);
            return;
        }
        if (PlayerExtensionsKt.isInBattle((ServerPlayer)$player)) {
            $player.displayClientMessage((Component)Component.translatable((String)"message.nbp.heal.battle_error").withColor(16580864), true);
            return;
        }
        HealPokemonCooldowns.INSTANCE.getLastHealUse().put($player.getUUID(), currentTime);
        PlayerPartyStore party = PlayerExtensionsKt.party((ServerPlayer)$player);
        party.heal();
        $player.displayClientMessage((Component)Component.translatable((String)"message.nbp.heal.success").withColor(65280), true);
    }
}

