/*
 * Decompiled with CFR 0.152.
 */
package com.nbp.cobblemon_smartphone.item;

import com.cobblemon.mod.common.CobblemonSounds;
import com.nbp.cobblemon_smartphone.client.gui.SmartphoneScreen;
import com.nbp.cobblemon_smartphone.item.SmartphoneColor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\nJ-\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J5\u0010\"\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010$\u00a8\u0006&"}, d2={"Lcom/nbp/cobblemon_smartphone/item/SmartphoneItem;", "Lnet/minecraft/world/item/Item;", "Lcom/nbp/cobblemon_smartphone/item/SmartphoneColor;", "model", "<init>", "(Lcom/nbp/cobblemon_smartphone/item/SmartphoneColor;)V", "getColor", "()Lcom/nbp/cobblemon_smartphone/item/SmartphoneColor;", "Lnet/minecraft/resources/ResourceLocation;", "getInventoryModel", "()Lnet/minecraft/resources/ResourceLocation;", "getHandModel", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "interactionHand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "itemStack", "", "getDescriptionId", "(Lnet/minecraft/world/item/ItemStack;)Ljava/lang/String;", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipContext", "", "Lnet/minecraft/network/chat/Component;", "list", "Lnet/minecraft/world/item/TooltipFlag;", "tooltipFlag", "", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Lcom/nbp/cobblemon_smartphone/item/SmartphoneColor;", "Companion", "cobblemon_smartphone-common"})
public final class SmartphoneItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SmartphoneColor model;
    public static final int MAX_STACK = 1;
    @NotNull
    public static final String BASE_REGISTRY_KEY = "_smartphone";
    @NotNull
    public static final String TRANSLATION_KEY = "item.cobblemon_smartphone.";
    @NotNull
    public static final String BASE_TOOLTIP_TRANSLATION_KEY = "item.cobblemon_smartphone.";

    public SmartphoneItem(@NotNull SmartphoneColor model) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        super(new Item.Properties().stacksTo(1));
        this.model = model;
    }

    @NotNull
    public final SmartphoneColor getColor() {
        return this.model;
    }

    @NotNull
    public final ResourceLocation getInventoryModel() {
        return this.model.getInventoryModelPath();
    }

    @NotNull
    public final ResourceLocation getHandModel() {
        return this.model.getHandModelPath();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        if (level.isClientSide()) {
            Minecraft.getInstance().setScreen((Screen)new SmartphoneScreen(this.model));
            player.playSound(CobblemonSounds.POKEDEX_OPEN, 0.5f, 1.0f);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    @NotNull
    public String getDescriptionId(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return "item.cobblemon_smartphone." + this.model.getModelName() + BASE_REGISTRY_KEY;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)tooltipContext, (String)"tooltipContext");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        MutableComponent mutableComponent = Component.translatable((String)("item.cobblemon_smartphone." + this.model.getModelName() + BASE_REGISTRY_KEY)).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        list.add((Component)mutableComponent);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/nbp/cobblemon_smartphone/item/SmartphoneItem$Companion;", "", "<init>", "()V", "", "MAX_STACK", "I", "", "BASE_REGISTRY_KEY", "Ljava/lang/String;", "TRANSLATION_KEY", "BASE_TOOLTIP_TRANSLATION_KEY", "cobblemon_smartphone-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

