/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.item;

import java.util.Objects;
import net.Pandarix.BACommon;
import net.Pandarix.entity.BombEntity;
import net.Pandarix.util.ServerPlayerHelper;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BombItem
extends Item {
    ResourceLocation ADVANCEMENT_ID = BACommon.createResource("used_bomb_item");

    public BombItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        pLevel.playSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
        BombEntity bombEntity = new BombEntity(pLevel, (LivingEntity)pPlayer);
        pPlayer.getCooldowns().addCooldown((Item)this, 10);
        if (!pLevel.isClientSide()) {
            bombEntity.setItem(itemStack);
            bombEntity.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), 0.0f, 0.75f, 1.0f);
            pLevel.addFreshEntity((Entity)bombEntity);
            AdvancementHolder advancement = Objects.requireNonNull(pLevel.getServer()).getAdvancements().get(this.ADVANCEMENT_ID);
            if (advancement != null) {
                ServerPlayerHelper.tryGetServerPlayer(pPlayer).ifPresent(sp -> sp.getAdvancements().award(advancement, "criteria"));
            }
        }
        pLevel.playSound(null, (Entity)bombEntity, SoundEvents.CREEPER_PRIMED, SoundSource.NEUTRAL, 1.0f, (float)pLevel.getRandom().nextDouble() * 0.5f + 0.5f);
        itemStack.shrink(1);
        return InteractionResultHolder.consume((Object)itemStack);
    }
}

