/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.advancedbackups.core.backups;

import computer.heather.advancedbackups.core.ABCore;
import computer.heather.advancedbackups.core.backups.BackupCheckEnum;
import computer.heather.advancedbackups.core.backups.BackupStatusInstance;
import computer.heather.advancedbackups.core.backups.BackupWrapper;
import computer.heather.advancedbackups.core.backups.ThreadedBackup;
import computer.heather.advancedbackups.core.config.ConfigManager;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;

public class BackupTimer {
    private static int loops = 0;
    private static int index = 0;
    private static long prev = 0L;
    private static long lastConsole = 0L;
    private static long lastClient = 0L;
    private static long lastAttempt = 0L;
    private static long nextBackup = System.currentTimeMillis() + BackupTimer.calculateNextBackupTime();

    public static void check() {
        BackupTimer.checkLogging();
        if (ThreadedBackup.running) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (ThreadedBackup.wasRunning) {
            ThreadedBackup.wasRunning = false;
            ABCore.enableSaving(false);
            nextBackup = BackupTimer.calculateNextBackupTime() + currentTime;
            return;
        }
        if (currentTime < nextBackup) {
            return;
        }
        lastAttempt = currentTime;
        if (BackupCheckEnum.SUCCESS.equals((Object)BackupWrapper.checkBackups())) {
            BackupWrapper.makeSingleBackup(5000L, false);
        } else {
            nextBackup = BackupTimer.calculateNextBackupTime() + currentTime;
        }
    }

    private static long calculateNextBackupTime() {
        long forcedMillis = (lastAttempt == 0L ? BackupWrapper.mostRecentBackupTime() : lastAttempt) + (long)(ConfigManager.maxFrequency.get().floatValue() * 3600000.0f);
        forcedMillis = forcedMillis <= System.currentTimeMillis() ? 300000L : (forcedMillis -= System.currentTimeMillis());
        long ret = Long.MAX_VALUE;
        if (ConfigManager.uptime.get().booleanValue() && !BackupWrapper.configuredPlaytime.isEmpty()) {
            ArrayList<Long> timings = new ArrayList<Long>(BackupWrapper.configuredPlaytime);
            if (index >= timings.size()) {
                index = 0;
                ++loops;
            }
            ret = timings.get(index) + timings.get(timings.size() - 1) * (long)loops;
            ret -= prev;
            prev += ret;
            ++index;
        } else if (!BackupWrapper.configuredPlaytime.isEmpty()) {
            long nextTime = 0L;
            long currentTime = System.currentTimeMillis();
            long startTime = LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * 1000L;
            ArrayList<Long> timings = new ArrayList<Long>(BackupWrapper.configuredPlaytime);
            for (long time : timings) {
                if ((time += startTime) < currentTime) continue;
                nextTime = time;
                break;
            }
            if (nextTime < currentTime) {
                startTime += 86400000L;
                for (long time : timings) {
                    if ((time += startTime) < currentTime) continue;
                    nextTime = time;
                    break;
                }
            }
            ret = nextTime - currentTime;
        }
        return Math.min(forcedMillis, ret);
    }

    private static void checkLogging() {
        if (BackupStatusInstance.getInstanceCopy() == null) {
            return;
        }
        BackupStatusInstance instance = BackupStatusInstance.getInstanceCopy();
        boolean console = false;
        boolean clients = false;
        long time = System.currentTimeMillis();
        if (time - ConfigManager.consoleFrequency.get() >= lastConsole) {
            console = true;
            if (instance.getAge() > lastConsole && ConfigManager.console.get().booleanValue()) {
                lastConsole = instance.getAge();
                if (instance.getState() == BackupStatusInstance.State.STARTED) {
                    int percent = (int)((float)instance.getProgress() / (float)instance.getMax() * 100.0f);
                    ABCore.infoLogger.accept("Backup in progress : " + percent + "%");
                }
            }
        }
        if (time - ConfigManager.clientFrequency.get() >= lastClient) {
            clients = true;
            if (instance.getAge() > lastClient && !"none".equals(ConfigManager.clients.get())) {
                ABCore.clientContactor.handle(instance, "all".equals(ConfigManager.clients.get()));
            }
        }
        if ((instance.getState() == BackupStatusInstance.State.COMPLETE || instance.getState() == BackupStatusInstance.State.CANCELLED || instance.getState() == BackupStatusInstance.State.FAILED) && console && clients) {
            BackupStatusInstance.setInstance(null);
        }
    }
}

