/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.advancedbackups.client;

import com.mojang.brigadier.CommandDispatcher;
import computer.heather.advancedbackups.client.AdvancedBackupsClientCommand;
import computer.heather.advancedbackups.client.BackupToast;
import computer.heather.advancedbackups.core.ABCore;
import computer.heather.advancedbackups.core.config.ClientConfigManager;
import computer.heather.advancedbackups.network.PacketBackupStatus;
import computer.heather.advancedbackups.network.PacketToastSubscribe;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.NetworkRegistry;

public class ClientWrapper {
    public static void handle(PacketBackupStatus packet, IPayloadContext context) {
        BackupToast.starting = packet.starting();
        BackupToast.started = packet.started();
        BackupToast.failed = packet.failed();
        BackupToast.finished = packet.finished();
        BackupToast.cancelled = packet.cancelled();
        BackupToast.progress = packet.progress();
        BackupToast.max = packet.max();
        if (!BackupToast.exists) {
            BackupToast.exists = true;
            Minecraft.getInstance().getToasts().addToast((Toast)new BackupToast());
        }
    }

    public static void init(FMLClientSetupEvent e) {
        NeoForge.EVENT_BUS.addListener(ClientWrapper::registerClientCommands);
        NeoForge.EVENT_BUS.addListener(ClientWrapper::onServerConnected);
        ClientConfigManager.loadOrCreateConfig();
    }

    public static void registerClientCommands(RegisterClientCommandsEvent event) {
        AdvancedBackupsClientCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void onServerConnected(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientWrapper.sendToServer(new PacketToastSubscribe(ClientConfigManager.showProgress.get()));
    }

    public static <MSG extends CustomPacketPayload> void sendToServer(MSG message) {
        ServerboundCustomPayloadPacket packet = new ServerboundCustomPayloadPacket(message);
        ClientPacketListener listener = Objects.requireNonNull(Minecraft.getInstance().getConnection());
        try {
            NetworkRegistry.checkPacket((Packet)packet, (ClientCommonPacketListener)listener);
        }
        catch (UnsupportedOperationException e) {
            ABCore.warningLogger.accept("Refusing to send packet " + String.valueOf(message) + " to server as the serve cannot receive it.");
            return;
        }
        listener.connection.send((Packet)packet);
    }
}

