/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.StringDecomposer;
import org.jetbrains.annotations.Nullable;

public class ComponentDecomposer {
    private static final Style EMPTY = Style.EMPTY.withColor(ChatFormatting.WHITE.getColor().intValue()).withBold(Boolean.valueOf(false)).withItalic(Boolean.valueOf(false)).withUnderlined(Boolean.valueOf(false)).withStrikethrough(Boolean.valueOf(false)).withObfuscated(Boolean.valueOf(false));

    public static String toFormattedString(Component component) {
        StringBuilder builder = new StringBuilder();
        component.visit((style, string) -> {
            builder.append(ComponentDecomposer.applyLegacyFormatting(string, style));
            return Optional.empty();
        }, Style.EMPTY);
        return builder.toString();
    }

    private static String applyLegacyFormatting(String string, Style style) {
        return ComponentDecomposer.toLegacyFormatting(style).stream().map(ChatFormatting::toString).reduce(String::concat).map(formattings -> formattings.concat(string).concat(ChatFormatting.RESET.toString())).orElse(string);
    }

    private static List<ChatFormatting> toLegacyFormatting(Style style) {
        ChatFormatting chatFormatting;
        ArrayList formattings = Lists.newArrayList();
        if (style.isEmpty()) {
            return formattings;
        }
        TextColor textColor = style.getColor();
        if (textColor != null && (chatFormatting = ChatFormatting.getByName((String)textColor.toString())) != null) {
            formattings.add(chatFormatting);
        }
        if (style.isBold()) {
            formattings.add(ChatFormatting.BOLD);
        }
        if (style.isItalic()) {
            formattings.add(ChatFormatting.ITALIC);
        }
        if (style.isUnderlined()) {
            formattings.add(ChatFormatting.UNDERLINE);
        }
        if (style.isStrikethrough()) {
            formattings.add(ChatFormatting.STRIKETHROUGH);
        }
        if (style.isObfuscated()) {
            formattings.add(ChatFormatting.OBFUSCATED);
        }
        return ImmutableList.copyOf((Collection)formattings);
    }

    public static Component toFormattedComponent(@Nullable String value) {
        return (Component)ComponentDecomposer.toComponentEntries(value).stream().map(entry -> Component.literal((String)entry.getValue()).withStyle(entry.getStyle())).reduce(MutableComponent::append).orElse(Component.empty());
    }

    public static String removeLast(@Nullable String value, int amount) {
        Deque<ComponentEntry> componentEntries = ComponentDecomposer.toComponentEntries(value);
        for (int i = 0; i < amount; ++i) {
            ComponentEntry componentEntry = componentEntries.peekLast();
            if (componentEntry == null) continue;
            if (!componentEntry.getValue().isEmpty()) {
                componentEntry.updateValue(s -> s.substring(0, s.length() - 1));
            }
            if (!componentEntry.getValue().isEmpty()) continue;
            componentEntries.pollLast();
        }
        return componentEntries.stream().map(entry -> ComponentDecomposer.applyLegacyFormatting(entry.getValue(), entry.getStyle())).collect(Collectors.joining());
    }

    private static Deque<ComponentEntry> toComponentEntries(@Nullable String value) {
        LinkedList values = Lists.newLinkedList();
        if (value == null) {
            return values;
        }
        AtomicBoolean resetStyle = new AtomicBoolean(true);
        StringDecomposer.iterateFormatted((String)value, (Style)EMPTY, (index, style, codePoint) -> {
            ComponentEntry last = (ComponentEntry)values.peekLast();
            if (last != null && last.getStyle().equals((Object)style)) {
                last.updateValue(s -> s + Character.toString(codePoint));
            } else {
                values.offerLast(new ComponentEntry(codePoint, style));
            }
            if (style != EMPTY) {
                resetStyle.set(false);
            }
            return true;
        });
        if (resetStyle.get()) {
            values.forEach(ComponentEntry::resetStyle);
        }
        return values;
    }

    public static int getStringLength(String value) {
        return ComponentDecomposer.toFormattedComponent(value).getString().length();
    }

    private static class ComponentEntry {
        private String value;
        private Style style;

        public ComponentEntry(int codePoint, Style style) {
            this.value = Character.toString(codePoint);
            this.style = style;
        }

        public String getValue() {
            return this.value;
        }

        public void updateValue(UnaryOperator<String> operator) {
            this.value = (String)operator.apply(this.value);
        }

        public Style getStyle() {
            return this.style;
        }

        public void resetStyle() {
            this.style = Style.EMPTY;
        }
    }
}

