/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class BuiltinAnimation<T extends Entity> {
    protected float jumpY = 0.0f;
    protected float prevJumpY = 0.0f;
    protected float yVel = 0.0f;

    void tick(T mob, Level world, BlockPos pos) {
        if (world.isClientSide) {
            ((Entity)mob).yOld = mob.getY();
            float dy = this.jumpY - this.prevJumpY;
            if (dy != 0.0f) {
                mob.setPos(mob.getX(), mob.getY() + (double)dy, mob.getZ());
            }
            this.prevJumpY = this.jumpY;
        }
    }

    @Nullable
    public static <E extends Entity> BuiltinAnimation<E> get(E entity, Type type) {
        if (type == Type.BUILTIN) {
            if (entity instanceof Slime) {
                Slime slime = (Slime)entity;
                return new SlimeAnim<Slime>(slime);
            }
            if (entity instanceof Chicken) {
                Chicken chicken = (Chicken)entity;
                return new ChickenAnim(chicken);
            }
            if (entity instanceof Rabbit) {
                Rabbit rabbit = (Rabbit)entity;
                return new RabbitAnim(rabbit);
            }
            if (entity instanceof Parrot) {
                Parrot parrot = (Parrot)entity;
                return new ParrotAnim(parrot);
            }
            if (entity instanceof Endermite) {
                Endermite endermite = (Endermite)entity;
                return new EndermiteAnim(endermite);
            }
        } else if (type == Type.FLOATING) {
            return new FloatingAnim<E>(entity);
        }
        return null;
    }

    public static enum Type implements StringRepresentable
    {
        NONE,
        LAND,
        AIR,
        FLOATING,
        BUILTIN;

        public static final Codec<Type> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Type> STREAM_CODEC;

        public boolean isFlying() {
            return this == AIR || this == FLOATING;
        }

        public boolean isLand() {
            return this == LAND;
        }

        public boolean isFloating() {
            return this == FLOATING;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            STREAM_CODEC = Utils.enumStreamCodec(Type.class);
        }
    }

    private static class SlimeAnim<M extends Slime>
    extends BuiltinAnimation<M> {
        SlimeAnim(M slime) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.isClientSide) {
                ((Slime)mob).squish += (((Slime)mob).targetSquish - ((Slime)mob).squish) * 0.5f;
                ((Slime)mob).oSquish = ((Slime)mob).squish;
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.04f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                        ((Slime)mob).targetSquish = -0.5f;
                    }
                    if ((double)world.getRandom().nextFloat() > 0.985) {
                        this.yVel = 0.15f;
                        ((Slime)mob).targetSquish = 1.0f;
                    }
                }
                ((Slime)mob).targetSquish *= 0.6f;
                super.tick(mob, world, pos);
            }
        }
    }

    private static class ChickenAnim<M extends Chicken>
    extends BuiltinAnimation<M> {
        public ChickenAnim(Chicken chicken) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            RandomSource rand = world.getRandom();
            if (!world.isClientSide) {
                if (--((Chicken)mob).eggTime <= 0) {
                    mob.spawnAtLocation((ItemLike)Items.EGG);
                    ((Chicken)mob).eggTime = rand.nextInt(6000) + 6000;
                }
            } else {
                mob.aiStep();
                double d = world.random.nextFloat();
                double d2 = mob.onGround() ? 0.99 : 0.88;
                if (d > d2) {
                    mob.setOnGround(!mob.onGround());
                }
            }
        }
    }

    private static class RabbitAnim<M extends Rabbit>
    extends BuiltinAnimation<M> {
        public RabbitAnim(Rabbit rabbit) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.isClientSide) {
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.017f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                    }
                    if ((double)world.random.nextFloat() > 0.985) {
                        this.yVel = 0.093f;
                        mob.startJumping();
                    }
                }
                mob.aiStep();
                super.tick(mob, world, pos);
            }
        }
    }

    private static class ParrotAnim<M extends Parrot>
    extends BuiltinAnimation<M> {
        public ParrotAnim(Parrot parrot) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.isClientSide) {
                mob.aiStep();
                boolean p = mob.isPartyParrot();
                mob.setOnGround(p);
                this.jumpY = p ? 0.0f : 0.0625f;
                super.tick(mob, world, pos);
            }
        }
    }

    private static class EndermiteAnim<M extends Endermite>
    extends BuiltinAnimation<M> {
        public EndermiteAnim(Endermite endermite) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.isClientSide && world.random.nextFloat() > 0.7f) {
                world.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.2f), (double)((float)pos.getZ() + 0.5f), (world.random.nextDouble() - 0.5) * 2.0, -world.random.nextDouble(), (world.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private static class FloatingAnim<M extends Entity>
    extends BuiltinAnimation<M> {
        FloatingAnim(M entity) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.isClientSide) {
                this.jumpY = 0.04f * Mth.sin((float)((float)((Entity)mob).tickCount / 10.0f)) - 0.03f;
            }
        }
    }
}

